(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    125738,       2648]*)
(*NotebookOutlinePosition[    126464,       2673]*)
(*  CellTagsIndexPosition[    126420,       2669]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Series de Fourier", "Title"],

Cell[TextData[StyleBox["Francisco Javier P\[EAcute]rez Gonz\[AAcute]lez\n\
Departamento de An\[AAcute]lisis Matem\[AAcute]tico\nUniversidad de Granada",
  FontSize->12]], "Author",
  TextAlignment->Right],

Cell[CellGroupData[{

Cell["Introducci\[OAcute]n", "Section"],

Cell[TextData[{
  "Recuerda que la ",
  StyleBox["serie de Fourier ",
    FontWeight->"Bold"],
  "de una funci\[OAcute]n ",
  StyleBox["T",
    FontSlant->"Italic"],
  "-peri\[OAcute]dica integrable ",
  StyleBox["f",
    FontSlant->"Italic"],
  " es la serie de funciones  "
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`a\_0/
        2 + \[Sum]\+\(k \[GreaterSlantEqual] 1\)\((a\_k\ \(cos(
                2  \[Pi]\ k\ t/T)\)\  + \ 
            b\_k\ \(sen(2\ \[Pi]\ k\ t/T)\))\)\)], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "donde los ",
  Cell[BoxData[
      \(TraditionalForm\`a\_k\)]],
  "se llaman ",
  StyleBox["coeficientes coseno",
    FontWeight->"Bold"],
  " y los ",
  Cell[BoxData[
      \(TraditionalForm\`b\_k\)]],
  " ",
  StyleBox["coefiecientes seno",
    FontWeight->"Bold"],
  " de",
  StyleBox[" ",
    FontWeight->"Bold"],
  StyleBox["f y ",
    FontSlant->"Italic"],
  "vienen dados por:"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          StyleBox[\(a\_k\),
            FontWeight->"Plain"], 
          StyleBox["=",
            FontWeight->"Plain"], 
          RowBox[{
            StyleBox[\(2\/T\),
              FontWeight->"Plain"], 
            RowBox[{
              StyleBox[\(\[Integral]\_\(\(-T\)/2\)\%\(T/2\)\),
                FontSize->14], 
              
              StyleBox[\(\(f(t)\) \(cos(
                    2  \[Pi]\ k\ t/
                        T)\) \[DifferentialD]t\ \ \ \ \ \((k \[GreaterEqual] 
                      0)\)\),
                FontWeight->"Plain"]}]}]}], 
        StyleBox[",",
          FontWeight->"Plain"], 
        StyleBox["       ",
          FontWeight->"Plain"], 
        RowBox[{
          StyleBox[\(b\_k\),
            FontWeight->"Plain"], 
          StyleBox["=",
            FontWeight->"Plain"], 
          RowBox[{
            StyleBox[\(2\/T\),
              FontWeight->"Plain"], 
            RowBox[{
              StyleBox[\(\[Integral]\_\(\(-T\)/2\)\%\(T/2\)\),
                FontSize->14,
                FontWeight->"Plain"], 
              RowBox[{
                StyleBox[\(f(t)\),
                  FontWeight->"Plain"], 
                StyleBox[\(sen(2  \[Pi]\ k\ t/T)\),
                  FontWeight->"Plain"], 
                StyleBox[\(\[DifferentialD]t\),
                  FontWeight->"Plain"], 
                StyleBox["      ",
                  FontWeight->"Plain"], 
                RowBox[{"(", 
                  StyleBox[\(k \[GreaterEqual] 1\),
                    FontWeight->"Plain"], 
                  StyleBox[")",
                    FontWeight->"Plain"]}]}]}]}]}]}], 
      TraditionalForm]], "Text",
  TextAlignment->Center],

Cell["Equivalentemente, podemos escribir dicha serie en la forma", "Text"],

Cell[BoxData[
    \(TraditionalForm\`\[Sum]\+\(k \[Element] \[DoubleStruckCapitalZ]\)c\_k\ \
e\^\(2  \[ImaginaryI]\ \[Pi]\ k\ t/T\)\)], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "donde ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(c\_k\),
          FontWeight->"Plain"], TraditionalForm]],
    FontWeight->"Bold"],
  " son los ",
  StyleBox["coeficientes de Fourier",
    FontWeight->"Bold"],
  " de ",
  StyleBox["f ",
    FontSlant->"Italic"],
  "y vienen dados por:"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        StyleBox[" ",
          FontWeight->"Plain"], 
        RowBox[{
          StyleBox[\(c\_k\),
            FontWeight->"Plain"], 
          StyleBox["=",
            FontWeight->"Plain"], 
          RowBox[{
            StyleBox[\(1\/T\),
              FontWeight->"Plain"], 
            RowBox[{
              StyleBox[\(\[Integral]\_\(\(-T\)/2\)\%\(T/2\)\),
                FontSize->14,
                FontWeight->"Plain"], 
              
              StyleBox[\(\(f(
                    t)\) \(e\^\(\(-2\) \[ImaginaryI]\ \[Pi]\ k\ t/
                          T\)\) \(\[DifferentialD]t\)\(\ \ \ \ \ \)\((k \
\[Element] \[DoubleStruckCapitalZ])\)\(\ \ \ \)\),
                FontWeight->"Plain"]}]}]}]}], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell["La funci\[OAcute]n", "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        StyleBox[" ",
          FontWeight->"Plain"], 
        RowBox[{
          StyleBox[\(\(S\_N\)(t)\),
            FontWeight->"Plain"], 
          StyleBox["=",
            FontWeight->"Plain"], 
          StyleBox[" ",
            FontWeight->"Plain"], 
          RowBox[{
            StyleBox[
              RowBox[{
                StyleBox[
                  UnderoverscriptBox[
                    StyleBox["\[Sum]",
                      FontSize->12], \(k = \(-N\)\), "N"],
                  FontSize->9,
                  FontWeight->"Plain"], 
                StyleBox[\(c\_k\ e\^\(2  \[ImaginaryI]\ \[Pi]\ k\ t/T\)\),
                  FontWeight->"Plain"]}],
              FontSize->12,
              FontWeight->"Plain"], 
            StyleBox["=",
              FontSize->12,
              FontWeight->"Plain"], 
            RowBox[{
              StyleBox[\(a\_0/2\),
                FontSize->12,
                FontWeight->"Plain"], 
              StyleBox["+",
                FontSize->12,
                FontWeight->"Plain"], 
              RowBox[{
                StyleBox[
                  UnderoverscriptBox[
                    StyleBox["\[Sum]",
                      FontSize->12], \(k = 1\), "N"],
                  FontSize->16,
                  FontWeight->"Plain"], 
                
                StyleBox[\((a\_k\ \(cos(2  \[Pi]\ k\ t/T)\)\  + \ 
                      b\_k\ \(sen(2\ \[Pi]\ k\ t/T)\))\),
                  FontSize->12,
                  FontWeight->"Plain"]}]}]}]}]}], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "se llama el ",
  StyleBox["polinomio de Fourier",
    FontWeight->"Bold"],
  " de orden N de ",
  StyleBox["f.",
    FontSlant->"Italic"]
}], "Text"],

Cell[TextData[{
  "Te propongo ahora, entre otras cosas, que calcules ",
  StyleBox["de forma simb\[OAcute]lica",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " los coeficientes de Fourier complejos as\[IAcute] como los coeficientes \
coseno y seno de algunas funciones sencillas. Al hacer estos c\[AAcute]lculos \
es frecuente que aparezcan algunas de las expresiones ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(Sin[n\ \[Pi]]\)\(,\)\)\)]],
  " ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(Cos[n\ \[Pi]]\), ",", " ", \(Exp[\[ImaginaryI]\ \[Pi]\ n]\),
           ",", " ", \(Exp[\(-\[ImaginaryI]\)\ \[Pi]\ n]\), ",", " ", 
          FormBox[\(\((\(-1\))\)\^n\),
            "TraditionalForm"]}], TraditionalForm]]],
  ", donde ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " es un n\[UAcute]mero entero. Conviene sustituir estas expresiones por sus \
correspondientes valores los cuales dependen de la paridad de ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  ". En la celda siguiente he definido un comando que hace estas \
simplificaciones. La sintaxis del comando es \"simplifica[expresion,variable]\
\" y lo que hace es atribuir localmente a \"variable\" el car\[AAcute]cter de \
n\[UAcute]mero entero y aplicar a \"expresion\" (se supone que \"expresion\" \
depende de \"variable\") un conjunto de reglas de sustituci\[OAcute]n \
apropiadas para reemplazar las expresiones antes se\[NTilde]aladas por sus \
valores."
}], "Text"],

Cell[TextData[{
  "Con ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 5 podemos usar el comando \"Simplify[expresion,condiciones]\"; por \
ejemplo podemos decirle a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 5 que simplifique una expresi\[OAcute]n en la que interviene una variable \
",
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  " y le informamos de que dicha variable toma valores enteros positivos con \
Simplify[expresion[k], k \[Element] Integers && k > 0]. Adem\[AAcute]s en ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 5 est\[AAcute]n implementadas las reglas de sustituci\[OAcute]n que usa \
el comando que se define en la siguiente celda; por eso, si trabajas con ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 5 o posterior no es preciso que eval\[UAcute]es dicha celda (aunque si lo \
haces tampoco causar\[AAcute] ning\[UAcute]n problema)."
}], "Text"],

Cell[BoxData[
    RowBox[{\(simplifica[expr__, n_]\), ":=", 
      RowBox[{"Module", "[", 
        RowBox[{\({par, impar, entero, reglas, st}\), ",", 
          
          RowBox[{\(impar[i_] := OddQ[i]\), ";", \(par[i_] := EvenQ[i]\), ";",
             " ", 
            
            StyleBox[\( (*\ 
                cambiamos\ el\ nombre\ para\ modificar\ la\ funci\[OAcute]n\ *) \
\),
              FontColor->RGBColor[1, 0, 0]], 
            "\n", \(impar[i_\ \ j_] := impar[i]\  && \ impar[j]\), ";", 
            
            StyleBox[\( (*\ 
                un\ producto\ de\ dos\ enteros\ es\ impar\ si\ ambos\ son\ \
impares\ *) \),
              FontColor->RGBColor[1, 0, 0]], 
            "\n", \(par[i_\ \ j_] := par[i]\  || par[j]\), ";", "\n", 
            
            StyleBox[\( (*\ 
                un\ producto\ de\ dos\ enteros\ es\ par\ si\ alguno\ es\ par\ \
*) \),
              FontColor->RGBColor[1, 0, 0]], 
            "\n", \(impar[
                i_\  + \ 
                  j_] := \((impar[i]\  && \ par[j]\ )\) || \ \((par[i]\  && \ 
                    impar[j]\ )\)\), ";", 
            
            StyleBox[\( (*\ 
                una\ suma\ de\ dos\ enteros\ es\ impar\ si\ tienen\ distinta\ \
paridad\ *) \),
              FontColor->RGBColor[1, 0, 0]], 
            "\n", \(par[
                i_\  + \ 
                  j_] := \((par[i]\  && \ par[j]\ )\) || \ \((impar[i]\  && \ 
                    impar[j]\ )\)\), ";", "\[IndentingNewLine]", 
            
            StyleBox[\( (*\ 
                una\ suma\ de\ dos\ enteros\ es\ par\ si\ ambos\ tienen\ \
igual\ paridad . \ 
                    Tambi\[EAcute]n\ a\[NTilde]adimos\ algunas\ definiciones\ \
a\ la\ funci\[OAcute]n\ IntegerQ\ *) \),
              FontColor->RGBColor[1, 0, 0]], \(entero[x_] := IntegerQ[x]\), 
            ";", \(entero[x_\ y_] := entero[x] && entero[y]\), 
            ";", \(entero[x_\  + \ y_] := entero[x] && entero[y]\), ";", 
            "\[IndentingNewLine]", 
            
            StyleBox[\( (*\ 
                ahora\ definimos\ unas\ reglas\ de\ sustituci\[OAcute]n\ \
apropiadas\ *) \),
              FontColor->RGBColor[1, 0, 0]], 
            "\n", \(reglas = {Sin[\ q_?entero\ \ \[Pi]] \[RuleDelayed] 0, 
                Cos[q_?entero\ \ \[Pi]] \[RuleDelayed] \((\(-1\))\)\^q, 
                Exp[\[ImaginaryI]\ \[Pi]\ q_?
                        entero] \[RuleDelayed] \((\(-1\))\)\^q, 
                Exp[\(-\[ImaginaryI]\)\ \[Pi]\ q_?
                        entero] \[RuleDelayed] \((\(-1\))\)\^q, 
                0^q_?entero \[RuleDelayed] 
                  0, \((\((\(-1\))\)^m_?entero)\)^
                    q_?entero \[RuleDelayed] \((\(-1\))\)^\((m\ q)\), \((\(-1\
\))\)^\((q_?impar\ \ m_)\) \[RuleDelayed] \ \((\(-1\))\)^m, \((\(-1\))\)^
                    q_?par \[RuleDelayed] 
                  1, \((\(-1\))\)^
                    q_?impar \[RuleDelayed] \(-1\), \((\(-1\))\)^
                    m_ \[RuleDelayed] \((\(-1\))\)\^m}\), ";", 
            "\[IndentingNewLine]", \(st /: \ entero[st] = True\), ";", 
            StyleBox[\( (*\ declaramos\ st\ como\ entero\ *) \),
              FontColor->RGBColor[1, 0, 0]], 
            "\[IndentingNewLine]", \(Simplify[
                Simplify[expr /. {n \[Rule] st}] //. reglas] /. 
              st \[Rule] n\)}]}], 
        StyleBox[\( (*\ 
            simplificamos\ la\ expresi\[OAcute]n\ sustituyendo\ n\ por\ st; \ 
            aplicamos\ las\ reglas\ repetidamente\ con\ el\ comando\  //. \ 
              y\ volvemos\ a\ simplificar\ y\ a\ sustituir\ st\ por\ n\ *) \),
          
          FontColor->RGBColor[1, 0, 0]], "]"}]}]], "Input"],

Cell["\<\
En el caso de que hayas evaluado la celda anterior, para comprobar si el \
comando funciona correctamente ejecuta la siguiente celda.\
\>", "Text"],

Cell[BoxData[{
    \(b[n_] := \(4\ \(Sin[\(n\ \[Pi]\)\/2]\^3\) Cos[\(\((n + 1)\)\ \
\[Pi]\)\/2]\^n\)\/\(\((\(-1\))\)\^\(3  n\) + \ n\ \[Pi]\)\), "\n", 
    \(simplifica[b[2  n], n]\), "\n", 
    \(simplifica[b[2  n - 1], n]\)}], "Input"],

Cell[TextData[{
  "Si est\[AAcute]s trabajando con ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 5 ejecuta la celda siguiente y compara los resultados obtenidos."
}], "Text"],

Cell[BoxData[{
    RowBox[{\(Simplify[b[2  n], n \[Element] Integers]\), 
      StyleBox[\( (*\ no\ funciona\ con\ Mathematica\ 3\ *) \),
        FontColor->RGBColor[1, 0, 0]]}], "\n", 
    RowBox[{\(Simplify[b[2  n - 1], n \[Element] Integers]\), 
      StyleBox[\( (*\ no\ funciona\ con\ Mathematica\ 3\ *) \),
        FontColor->RGBColor[1, 0, 0]], "\[IndentingNewLine]", 
      StyleBox[\( (*\ no\ podemos\ simplificar\ directamente\ b[n]\ *) \),
        FontColor->RGBColor[1, 0, 0]]}], "\n", \(simplifica[b[n], n]\), "\n", 
  
    RowBox[{\(Simplify[b[n], n \[Element] Integers]\), 
      StyleBox[\( (*\ no\ funciona\ con\ Mathematica\ 3\ *) \),
        FontColor->RGBColor[1, 0, 0]]}], "\n", \(Clear[b]\)}], "Input"],

Cell["\<\
Te aconsejo que seas precavido al usar el comando \"simplifica[ ]\", pues no \
estoy totalmente seguro de que sea infalible. Por ello debes comprobar  \
cualquier resultado que no te convenza. \
\>", "Text"],

Cell["\<\
En los ejercicios siguientes debes calcular, unas veces de forma \
simb\[OAcute]lica y otras de forma num\[EAcute]rica, los coeficientes de \
Fourier de unas cuantas funciones y hacer algunas animaciones \
gr\[AAcute]ficas para comprobar c\[OAcute]mo los polinomios de Fourier se van \
aproximando a la funci\[OAcute]n. Adem\[AAcute]s deber\[AAcute]s representar \
en cada caso los espectros de amplitudes y de fases.\
\>", "Text"],

Cell["\<\
Para representar los espectros de amplitudes y de fases debes recordar la \
relaci\[OAcute]n entre los coefiecientes de Fourier y los coeficientes seno y \
coseno que viene dada por:\
\>", "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          FormBox[\(c\_0 = a\_0\/2\),
            "TraditionalForm"], 
          
          FormBox[\(\(,\)\(\ \)\(c\_n = \(a\_n\  - \ \[ImaginaryI]\ b\_n\)\/2\
\)\(,\)\(\ \)\(c\_\(-n\) = \(a\_n\  + \ \[ImaginaryI]\ b\_n\)\/2\)\),
            "TraditionalForm"]}], ",", " ", \(n = 1\), ",", "2", ",", "..."}],
       TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Recuerda que el espectro de una se\[NTilde]al cuya serie de Fourier \
compleja es ",
  Cell[BoxData[
      \(TraditionalForm\`\[Sum]\+\(k \[Element] \[DoubleStruckCapitalZ]\)c\_k\
\ e\^\(2  \[ImaginaryI]\ \[Pi]\ k\ t/T\)\)]],
  " se define como el conjunto de puntos ",
  Cell[BoxData[
      \(TraditionalForm\`{\((n/T, c\_n)\) : 
          n \[Element] \[DoubleStruckZ]}\)]],
  ". El ",
  StyleBox["espectro de amplitudes",
    FontWeight->"Bold"],
  " es el conjunto  ",
  Cell[BoxData[
      \(TraditionalForm\`{\((n/T, Abs[c\_n])\) : 
          n \[Element] \[DoubleStruckZ]}\)]],
  " y el ",
  StyleBox["espectro de fases",
    FontWeight->"Bold"],
  " es el conjunto ",
  Cell[BoxData[
      \(TraditionalForm\`{\((n/T, Arg[c\_n])\) : 
          n \[Element] \[DoubleStruckZ]}\)]],
  " dichos conjuntos suelen representarse por segmentos de l\[IAcute]nea que \
unen los puntos ",
  Cell[BoxData[
      \(TraditionalForm\`\((n/T, 0)\)\)]],
  " con los puntos del espectro correspondiente. Deben quedar, m\[AAcute]s o \
menos, como los ves aqu\[IAcute] debajo."
}], "Text"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .2943 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.00700719 0.47619 [
[ 0 0 0 0 ]
[ 1 .2943 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .2943 L
0 .2943 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.00700719 0.477324 0.287295 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.0238095 0.0686704 0.686704 [
[.02381 .05617 -9 -9 ]
[.02381 .05617 9 0 ]
[.2619 .05617 -9 -9 ]
[.2619 .05617 9 0 ]
[.7381 .05617 -6 -9 ]
[.7381 .05617 6 0 ]
[.97619 .05617 -6 -9 ]
[.97619 .05617 6 0 ]
[.4875 .20601 -18 -4.5 ]
[.4875 .20601 0 4.5 ]
[.4875 .34335 -18 -4.5 ]
[.4875 .34335 0 4.5 ]
[.4875 .48069 -18 -4.5 ]
[.4875 .48069 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .06867 m
.02381 .07492 L
s
[(-20)] .02381 .05617 0 1 Mshowa
.2619 .06867 m
.2619 .07492 L
s
[(-10)] .2619 .05617 0 1 Mshowa
.7381 .06867 m
.7381 .07492 L
s
[(10)] .7381 .05617 0 1 Mshowa
.97619 .06867 m
.97619 .07492 L
s
[(20)] .97619 .05617 0 1 Mshowa
.125 Mabswid
.07143 .06867 m
.07143 .07242 L
s
.11905 .06867 m
.11905 .07242 L
s
.16667 .06867 m
.16667 .07242 L
s
.21429 .06867 m
.21429 .07242 L
s
.30952 .06867 m
.30952 .07242 L
s
.35714 .06867 m
.35714 .07242 L
s
.40476 .06867 m
.40476 .07242 L
s
.45238 .06867 m
.45238 .07242 L
s
.54762 .06867 m
.54762 .07242 L
s
.59524 .06867 m
.59524 .07242 L
s
.64286 .06867 m
.64286 .07242 L
s
.69048 .06867 m
.69048 .07242 L
s
.78571 .06867 m
.78571 .07242 L
s
.83333 .06867 m
.83333 .07242 L
s
.88095 .06867 m
.88095 .07242 L
s
.92857 .06867 m
.92857 .07242 L
s
.25 Mabswid
0 .06867 m
1 .06867 L
s
.5 .20601 m
.50625 .20601 L
s
[(0.2)] .4875 .20601 1 0 Mshowa
.5 .34335 m
.50625 .34335 L
s
[(0.4)] .4875 .34335 1 0 Mshowa
.5 .48069 m
.50625 .48069 L
s
[(0.6)] .4875 .48069 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(0.8)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .10301 m
.50375 .10301 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .17168 m
.50375 .17168 L
s
.5 .24035 m
.50375 .24035 L
s
.5 .27468 m
.50375 .27468 L
s
.5 .30902 m
.50375 .30902 L
s
.5 .37769 m
.50375 .37769 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .44636 m
.50375 .44636 L
s
.5 .51503 m
.50375 .51503 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .5837 m
.50375 .5837 L
s
.5 .03434 m
.50375 .03434 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .06867 m
.02381 .06867 L
s
.04762 .06867 m
.04762 .09168 L
s
.07143 .06867 m
.07143 .06867 L
s
.09524 .06867 m
.09524 .09439 L
s
.11905 .06867 m
.11905 .06867 L
s
.14286 .06867 m
.14286 .09782 L
s
.16667 .06867 m
.16667 .06867 L
s
.19048 .06867 m
.19048 .1023 L
s
.21429 .06867 m
.21429 .06867 L
s
.2381 .06867 m
.2381 .10841 L
s
.2619 .06867 m
.2619 .06867 L
s
.28571 .06867 m
.28571 .11724 L
s
.30952 .06867 m
.30952 .06867 L
s
.33333 .06867 m
.33333 .13112 L
s
.35714 .06867 m
.35714 .06867 L
s
.38095 .06867 m
.38095 .1561 L
s
.40476 .06867 m
.40476 .06867 L
s
.42857 .06867 m
.42857 .21439 L
s
.45238 .06867 m
.45238 .06867 L
s
.47619 .06867 m
.47619 .50584 L
s
.5 .06867 m
.5 .06867 L
s
.52381 .06867 m
.52381 .50584 L
s
.54762 .06867 m
.54762 .06867 L
s
.57143 .06867 m
.57143 .21439 L
s
.59524 .06867 m
.59524 .06867 L
s
.61905 .06867 m
.61905 .1561 L
s
.64286 .06867 m
.64286 .06867 L
s
.66667 .06867 m
.66667 .13112 L
s
.69048 .06867 m
.69048 .06867 L
s
.71429 .06867 m
.71429 .11724 L
s
.7381 .06867 m
.7381 .06867 L
s
.7619 .06867 m
.7619 .10841 L
s
.78571 .06867 m
.78571 .06867 L
s
.80952 .06867 m
.80952 .1023 L
s
.83333 .06867 m
.83333 .06867 L
s
.85714 .06867 m
.85714 .09782 L
s
.88095 .06867 m
.88095 .06867 L
s
.90476 .06867 m
.90476 .09439 L
s
.92857 .06867 m
.92857 .06867 L
s
.95238 .06867 m
.95238 .09168 L
s
.97619 .06867 m
.97619 .06867 L
s
1 0 0 r
.0185 w
.02381 .06867 Mdot
.04762 .09168 Mdot
.07143 .06867 Mdot
.09524 .09439 Mdot
.11905 .06867 Mdot
.14286 .09782 Mdot
.16667 .06867 Mdot
.19048 .1023 Mdot
.21429 .06867 Mdot
.2381 .10841 Mdot
.2619 .06867 Mdot
.28571 .11724 Mdot
.30952 .06867 Mdot
.33333 .13112 Mdot
.35714 .06867 Mdot
.38095 .1561 Mdot
.40476 .06867 Mdot
.42857 .21439 Mdot
.45238 .06867 Mdot
.47619 .50584 Mdot
.5 .06867 Mdot
.52381 .50584 Mdot
.54762 .06867 Mdot
.57143 .21439 Mdot
.59524 .06867 Mdot
.61905 .1561 Mdot
.64286 .06867 Mdot
.66667 .13112 Mdot
.69048 .06867 Mdot
.71429 .11724 Mdot
.7381 .06867 Mdot
.7619 .10841 Mdot
.78571 .06867 Mdot
.80952 .1023 Mdot
.83333 .06867 Mdot
.85714 .09782 Mdot
.88095 .06867 Mdot
.90476 .09439 Mdot
.92857 .06867 Mdot
.95238 .09168 Mdot
.97619 .06867 Mdot
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.00700719 0.97619 0.287295 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.0238095 0.309017 0.187358 [
[.02381 .29652 -9 -9 ]
[.02381 .29652 9 0 ]
[.2619 .29652 -9 -9 ]
[.2619 .29652 9 0 ]
[.7381 .29652 -6 -9 ]
[.7381 .29652 6 0 ]
[.97619 .29652 -6 -9 ]
[.97619 .29652 6 0 ]
[.4875 .02798 -24 -4.5 ]
[.4875 .02798 0 4.5 ]
[.4875 .12166 -12 -4.5 ]
[.4875 .12166 0 4.5 ]
[.4875 .21534 -24 -4.5 ]
[.4875 .21534 0 4.5 ]
[.4875 .4027 -18 -4.5 ]
[.4875 .4027 0 4.5 ]
[.4875 .49638 -6 -4.5 ]
[.4875 .49638 0 4.5 ]
[.4875 .59005 -18 -4.5 ]
[.4875 .59005 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-20)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-10)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(10)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(20)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.07143 .30902 m
.07143 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.16667 .30902 m
.16667 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.35714 .30902 m
.35714 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.45238 .30902 m
.45238 .31277 L
s
.54762 .30902 m
.54762 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.64286 .30902 m
.64286 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.83333 .30902 m
.83333 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.92857 .30902 m
.92857 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 .02798 m
.50625 .02798 L
s
[(-1.5)] .4875 .02798 1 0 Mshowa
.5 .12166 m
.50625 .12166 L
s
[(-1)] .4875 .12166 1 0 Mshowa
.5 .21534 m
.50625 .21534 L
s
[(-0.5)] .4875 .21534 1 0 Mshowa
.5 .4027 m
.50625 .4027 L
s
[(0.5)] .4875 .4027 1 0 Mshowa
.5 .49638 m
.50625 .49638 L
s
[(1)] .4875 .49638 1 0 Mshowa
.5 .59005 m
.50625 .59005 L
s
[(1.5)] .4875 .59005 1 0 Mshowa
.125 Mabswid
.5 .04672 m
.50375 .04672 L
s
.5 .06545 m
.50375 .06545 L
s
.5 .08419 m
.50375 .08419 L
s
.5 .10292 m
.50375 .10292 L
s
.5 .14039 m
.50375 .14039 L
s
.5 .15913 m
.50375 .15913 L
s
.5 .17787 m
.50375 .17787 L
s
.5 .1966 m
.50375 .1966 L
s
.5 .23407 m
.50375 .23407 L
s
.5 .25281 m
.50375 .25281 L
s
.5 .27155 m
.50375 .27155 L
s
.5 .29028 m
.50375 .29028 L
s
.5 .32775 m
.50375 .32775 L
s
.5 .34649 m
.50375 .34649 L
s
.5 .36522 m
.50375 .36522 L
s
.5 .38396 m
.50375 .38396 L
s
.5 .42143 m
.50375 .42143 L
s
.5 .44017 m
.50375 .44017 L
s
.5 .4589 m
.50375 .4589 L
s
.5 .47764 m
.50375 .47764 L
s
.5 .51511 m
.50375 .51511 L
s
.5 .53385 m
.50375 .53385 L
s
.5 .55258 m
.50375 .55258 L
s
.5 .57132 m
.50375 .57132 L
s
.5 .00924 m
.50375 .00924 L
s
.5 .60879 m
.50375 .60879 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
.5 Mabswid
.02381 .30902 m
.02381 .30902 L
s
.04762 .30902 m
.04762 .60332 L
s
.07143 .30902 m
.07143 .30902 L
s
.09524 .30902 m
.09524 .60332 L
s
.11905 .30902 m
.11905 .30902 L
s
.14286 .30902 m
.14286 .60332 L
s
.16667 .30902 m
.16667 .30902 L
s
.19048 .30902 m
.19048 .60332 L
s
.21429 .30902 m
.21429 .30902 L
s
.2381 .30902 m
.2381 .60332 L
s
.2619 .30902 m
.2619 .30902 L
s
.28571 .30902 m
.28571 .60332 L
s
.30952 .30902 m
.30952 .30902 L
s
.33333 .30902 m
.33333 .60332 L
s
.35714 .30902 m
.35714 .30902 L
s
.38095 .30902 m
.38095 .60332 L
s
.40476 .30902 m
.40476 .30902 L
s
.42857 .30902 m
.42857 .60332 L
s
.45238 .30902 m
.45238 .30902 L
s
.47619 .30902 m
.47619 .60332 L
s
.5 .30902 m
.5 .30902 L
s
.52381 .30902 m
.52381 .01472 L
s
.54762 .30902 m
.54762 .30902 L
s
.57143 .30902 m
.57143 .01472 L
s
.59524 .30902 m
.59524 .30902 L
s
.61905 .30902 m
.61905 .01472 L
s
.64286 .30902 m
.64286 .30902 L
s
.66667 .30902 m
.66667 .01472 L
s
.69048 .30902 m
.69048 .30902 L
s
.71429 .30902 m
.71429 .01472 L
s
.7381 .30902 m
.7381 .30902 L
s
.7619 .30902 m
.7619 .01472 L
s
.78571 .30902 m
.78571 .30902 L
s
.80952 .30902 m
.80952 .01472 L
s
.83333 .30902 m
.83333 .30902 L
s
.85714 .30902 m
.85714 .01472 L
s
.88095 .30902 m
.88095 .30902 L
s
.90476 .30902 m
.90476 .01472 L
s
.92857 .30902 m
.92857 .30902 L
s
.95238 .30902 m
.95238 .01472 L
s
.97619 .30902 m
.97619 .30902 L
s
1 0 0 r
.0185 w
.02381 .30902 Mdot
.04762 .60332 Mdot
.07143 .30902 Mdot
.09524 .60332 Mdot
.11905 .30902 Mdot
.14286 .60332 Mdot
.16667 .30902 Mdot
.19048 .60332 Mdot
.21429 .30902 Mdot
.2381 .60332 Mdot
.2619 .30902 Mdot
.28571 .60332 Mdot
.30952 .30902 Mdot
.33333 .60332 Mdot
.35714 .30902 Mdot
.38095 .60332 Mdot
.40476 .30902 Mdot
.42857 .60332 Mdot
.45238 .30902 Mdot
.47619 .60332 Mdot
.5 .30902 Mdot
.52381 .01472 Mdot
.54762 .30902 Mdot
.57143 .01472 Mdot
.59524 .30902 Mdot
.61905 .01472 Mdot
.64286 .30902 Mdot
.66667 .01472 Mdot
.69048 .30902 Mdot
.71429 .01472 Mdot
.7381 .30902 Mdot
.7619 .01472 Mdot
.78571 .30902 Mdot
.80952 .01472 Mdot
.83333 .30902 Mdot
.85714 .01472 Mdot
.88095 .30902 Mdot
.90476 .01472 Mdot
.92857 .30902 Mdot
.95238 .01472 Mdot
.97619 .30902 Mdot
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{450.188, 132.5},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000:S0000aR000`400?l00000o`00003oo`3ooooo
0?ooojD0oooo003o0?ooool0ooooY@3oool00?l0ooooo`3ooonU0?ooo`00o`3ooooo0?ooojD0oooo
002[0?ooo`030000003oool0oooo0?l0oooomP3oool00:/0oooo00<000000?ooo`3oool0o`3oooof
0?ooo`00Z`3oool00`000000oooo0?ooo`3o0?ooooH0oooo002[0?ooo`030000003oool0oooo0?l0
ooooC@3oool00`000000oooo0?ooo`2V0?ooo`00Z`3oool00`000000oooo0?ooo`3o0?ooodd0oooo
00<000000?ooo`3oool0YP3oool001/0oooo00<0oooD09/000000000100000001@2Ke?l0oooo0?oo
o`3oool0omBK00<0000000<0VmCo0?ooo`3oool0=@3oool00`3oe9/000000000000300000005002K
e03oool0oooo0?ooo`3oe9/00`0000000`2Ke?l0oooo0?ooo`0h0?ooo`030000003oool0oooo03/0
oooo00<0omBK0000000000000`0000001@00Vm@0oooo0?ooo`3oool0omBK00<0000000<0VmCo0?oo
o`3oool0=03oool00`3oom@0V`00000000040000000509_Do`3oool0oooo0?ooo`3oe9/00`000000
0`2Ke?l0oooo0?ooo`2j0?ooo`030000003oool0oooo0:H0oooo000L0?ooo`030=BK000009/0e?oo
0080oooo00<0j[ZK0;[Zo`3oool00P3oool01P2jLY/0e?oo0?ooo`3oom@0V`2K0=CoocT0oooo00<0
^W9b0;[Zo`3oool0103oool01P2jLY/0e?oo0?ooo`3oom@0V`2K0=CoocT0oooo00<000000?ooo`3o
ool0?P3oool00`2jLW80^^[o0?ooo`040?ooo`060;YbV`3Dool0oooo0?ooe02K09/0e?oo=P3oool0
0`3DV`00002K0=Coo`020?ooo`030>ZjV`2jj_l0oooo0080oooo00H0^W:K0=Coo`3oool0oooD09/0
V`3Doonk0?ooo`<000000`3oool30?l000/0oooo0`3o000<0?ooo`<0o`002`3oool30?l000/0oooo
0`3o000;0?ooo`<0o`002`3oool30?l000/0oooo0`3o000;0?ooo`<0o`002`3oool30?l00240oooo
000M0?ooo`030?oDV`000780^^[o00D0oooo00<0omBK002Ke03oool00P3oool00`3Z^W80L[[Z0?oo
o`0h0?ooo`030;YbLP2jj_l0oooo00<0oooo00<0omBK002Ke03oool00P3oool00`3Z^W80L[[Z0?oo
o`0h0?ooo`030000003oool0oooo03h0oooo00<0^W9b0;[Zo`3oool00`3oool00`3oe9/009_D0?oo
o`020?ooo`030>ZjLP1b^^X0oooo03H0oooo00<0omBK0000LP2jj_l01@3oool00`3oe9/009_D0?oo
o`020?ooo`030>ZjLP1b^^X0oooo0;X0oooo00<000000?ooo`3oool00P3oool50?l000T0oooo1@3o
000:0?ooo`D0o`002@3oool50?l000T0oooo1@3o00090?ooo`D0o`002@3oool50?l000T0oooo1@3o
00090?ooo`D0o`002@3oool50?l00200oooo000N0?ooo`030?oZ^P1b0000L[[Z00@0oooo00<0j[Yb
07:jjP3oool00P3oool00`3oe9/009_D0?ooo`0h0?ooo`030;YbLP2jj_l0oooo00<0oooo00<0j[Yb
07:jjP3oool00P3oool00`3oe9/009_D0?ooo`0h0?ooo`030000003oool0oooo03h0oooo00<0^W9b
0;[Zo`3oool00`3oool00`3Z^W80L[[Z0?ooo`020?ooo`030?oDV`00Vm@0oooo03L0oooo00<0onZj
0780001b^^X0103oool00`3Z^W80L[[Z0?ooo`020?ooo`030?oDV`00Vm@0oooo09d0oooo00<0omBK
0000000000000`0000000`00Vm@0oooo0?ooo`020?ooo`030=BK0000000009_D00D0oooo00D0e9/0
000000000000000009_Do`050?ooo`030000003oool0oooo0080oooo1@3o00090?ooo`D0o`002P3o
ool50?l000T0oooo1@3o00090?ooo`D0o`002@3oool50?l000T0oooo1@3o00090?ooo`D0o`002@3o
ool50?l000T0oooo1@3o000P0?ooo`004`3oool00`2jLP0000000000000300000003001b^P3oool0
oooo00@0oooo00<0^W8007:jjP3oool00P3oool00`3Z^W80L[[Z0?ooo`020?ooo`030?oDV`00Vm@0
oooo02`0oooo00<0^W800000000000000`0000000`00L[X0oooo0?ooo`030?ooo`030;YbLP2jj_l0
oooo00<0oooo00<0j[Yb07:jjP3oool00P3oool00`3oe9/009_D0?ooo`0h0?ooo`030000003oool0
oooo03h0oooo00<0^W9b0;[Zo`3oool00`3oool00`3Z^W80L[[Z0?ooo`020?ooo`030?oDV`00Vm@0
oooo03T0oooo00<0^W8007:jjP3oool00P3oool00`3Z^W80L[[Z0?ooo`020?ooo`030?oDV`00Vm@0
oooo0:00oooo00<0^W9b0;[Zo`3oool01@3oool00`3DV`000000002Ke0040?ooo`070=BK0000Vm@0
oooo0?ooo`3oj[X0LP0009_Do`040?ooo`030000003oool0oooo0080oooo1@3o00090?ooo`D0o`00
2P3oool50?l000T0oooo1@3o00090?ooo`D0o`002@3oool50?l000T0oooo1@3o00090?ooo`D0o`00
2@3oool50?l000T0oooo1@3o000P0?ooo`008@3oool01P2jLY/0e?oo0?ooo`3oool0j[Yb07:jjP<0
oooo00<0omBK002Ke03oool0>03oool00`2jLW80^^[o0?ooo`030?ooo`030>ZjLP1b^^X0oooo0080
oooo00<0omBK002Ke03oool0>03oool00`000000oooo0?ooo`0n0?ooo`030;YbLP2jj_l0oooo00<0
oooo00<0j[Yb07:jjP3oool00P3oool00`3oe9/009_D0?ooo`0j0?ooo`060;YbV`3Dool0oooo0?oo
o`3Z^W80L[[Z0`3oool00`3oe9/009_D0?ooo`2P0?ooo`030;YbLP2jj_l0oooo0140oooo00<0omBK
002Ke03oool00`3oool00`000000oooo0?ooo`030?ooo`<0o`002`3oool30?l000`0oooo0`3o000;
0?ooo`<0o`002`3oool30?l000/0oooo0`3o000;0?ooo`<0o`002`3oool30?l000/0oooo0`3o000;
0?ooo`<0o`008@3oool001`0oooo00<0j[Yb09_Do`3oool00P3oool01P3DV`00VmCo0?ooo`3oool0
omBK07:jjP<0oooo00<0j[Yb07:jjP3oool0>03oool00`2jLW80^^[o0?ooo`030?ooo`030?oDV`1b
^^X0oooo0080oooo00<0j[Yb07:jjP3oool0>03oool2000003l0oooo00<0^W9b0;[Zo`3oool00`3o
ool00`3oe9/0L[[Z0?ooo`020?ooo`030>ZjLP1b^^X0oooo03D0oooo00<0j[Yb09_Do`3oool00P3o
ool01P3DV`00VmCo0?ooo`3oool0omBK07:jjP<0oooo00<0j[Yb07:jjP3oool0X03oool00`2jLW80
^^[o0?ooo`0A0?ooo`030?oDV`00Vm@0oooo00<0oooo0`0000040?ooo`030000003oool0oooo00`0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo01l0
oooo000L0?ooo`070?oDV`0009/0e?oo0?ooo`3oe9/0001b0;[Zo`030?ooo`060;Yb002Ke?l0oooo
0?oZ^P1b09/0e?oo=P3oool01@3Z^W800000001b^P2jLW80^^[o00D0oooo00H0^W8009_Do`3oool0
onZj0780V`3Dooli0?ooo`030000003oool0oooo03/0oooo00D0j[Yb00000000L[X0^W9b0;[Zo`05
0?ooo`060;Yb002Ke?l0oooo0?oZ^P1b09/0e?oo=P3oool01`3oe9/0002K0=Coo`3oool0omBK0000
LP2jj_l00`3oool01P2jLP00VmCo0?ooo`3oj[X0LP2K0=CooiD0oooo00<0^W800000000000000`00
00000`00L[X0oooo0?ooo`030?ooo`030;YbLP2jj_l0oooo0140oooo00<0^W8009_Do`3oool00`3o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo01l0oooo000M0?ooo`050?oDV`000000
00000000LP2jj_l0103oool01@3oom@0V`00000000000780^^[o03T0oooo00<0j[Yb0000LP2jj_l0
1@3oool01@3oom@0V`00000000000780^^[o03X0oooo00<000000?ooo`3oool0?@3oool00`3Z^W80
001b0;[Zo`050?ooo`050?ooe02K000000000000LP2jj_l0>03oool01@3oe9/00000000000000780
^^[o00@0oooo00D0oooD09/000000000001b0;[Zo`2R0?ooo`030;YbLP2jj_l0oooo00`0oooo00<0
oooD09/0000000000P0000000`1b^^X0oooo0?ooo`030?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<0
00000?ooo`3oool07`3oool00:/0oooo00<000000?ooo`3oool0o`3ooolc0?ooo`030;YbLP2jj_l0
oooo00`0oooo00<0oooD09/0V`3Dool0203oool00`000000oooo0?ooo`040?ooo`030000003oool0
oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0
oooo01l0oooo002[0?ooo`030000003oool0oooo0?l0oooo<03oool01@3Z^W800000001b^P2jLW80
^^[o00d0oooo00<0oooD09/0V`3Dool0203oool00`000000oooo0?ooo`040?ooo`030000003oool0
oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0
oooo01l0oooo002[0?ooo`030000003oool0oooo0?l0oooo<P3oool00`3Z^W80001b0;[Zo`0=0?oo
o`030?ooe02K000000000080000000<0002K0=Coo`3oool00`3oool00`000000oooo0?ooo`040?oo
o`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?oo
o`030000003oool0oooo01l0oooo002[0?ooo`030000003oool0oooo0?l0ooooC@3oool3000000@0
oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0
oooo00<000000?ooo`3oool07`3oool00:/0oooo00<000000?ooo`3oool0o`3ooom=0?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00`0oooo00<000000?ooo`3oool07`3oool001h0oooo0`3o000;0?ooo`<0o`002`3o
ool30?l000/0oooo0`3o000;0?ooo`<0o`002`3oool30?l000/0oooo0`3o000;0?ooo`<0o`002`3o
ool30?l000/0oooo0`3o000;0?ooo`<0o`002`3oool30?l000/0oooo0`3o000;0?ooo`<0o`002`3o
ool30?l000/0oooo0`3o000;0?ooo`<0o`002`3oool30?l000/0oooo0`3o000;0?ooo`<0o`002`3o
ool30?l00<40oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0<0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0O0?ooo`007@3oool5
0?l000T0oooo1@3o00090?ooo`D0o`002@3oool50?l000T0oooo1@3o00090?ooo`D0o`002@3oool5
0?l000T0oooo1@3o00090?ooo`D0o`002@3oool50?l000T0oooo1@3o00090?ooo`D0o`002@3oool5
0?l000T0oooo1@3o00090?ooo`D0o`002@3oool50?l000T0oooo1@3o00090?ooo`D0o`002@3oool5
0?l000T0oooo1@3o00090?ooo`D0o`00`03oool00`000000oooo0?ooo`040?ooo`030000003oool0
oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0
oooo01l0oooo000H0?ooo`D000001@3o0009000000D0o`002@0000050?l000T000001@3o00090000
00D0o`002@0000050?l000T000001@3o0009000000D0o`002@0000050?l000T000001@3o00090000
00D0o`002@0000050?l000T000001@3o0009000000D0o`002@0000050?l000T000001@3o00090000
00D0o`002@0000050?l000T000001@3o0009000000D0o`002@0000050?l000D00000^`3oool00`00
0000oooo0?ooo`040?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0<0?ooo`030000003oool0oooo01l0oooo000M0?ooo`D0o`00103oool00`000000
oooo0?ooo`020?ooo`D0o`00103oool00`000000oooo0?ooo`020?ooo`D0o`00103oool00`000000
oooo0?ooo`020?ooo`D0o`00103oool00`000000oooo0?ooo`020?ooo`D0o`00103oool00`000000
oooo0?ooo`020?ooo`D0o`00103oool00`000000oooo0?ooo`020?ooo`D0o`00103oool00`000000
oooo0?ooo`020?ooo`D0o`00103oool00`000000oooo0?ooo`020?ooo`D0o`00103oool00`000000
oooo0?ooo`020?ooo`D0o`00103oool00`000000oooo0?ooo`020?ooo`D0o`00103oool00`000000
oooo0?ooo`020?ooo`D0o`00103oool00`000000oooo0?ooo`020?ooo`D0o`00103oool00`000000
oooo0?ooo`020?ooo`D0o`00103oool00`000000oooo0?ooo`020?ooo`D0o`00103oool00`000000
oooo0?ooo`020?ooo`D0o`00103oool00`000000oooo0?ooo`020?ooo`D0o`00103oool00`000000
oooo0?ooo`020?ooo`D0o`00103oool00`000000oooo0?ooo`020?ooo`D0o`00103oool00`000000
oooo0?ooo`020?ooo`D0o`00103oool00`000000oooo0?ooo`020?ooo`D0o`00`03oool3000000@0
oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0
oooo00<000000?ooo`3oool07`3oool001h0oooo0`3o00050?ooo`030000003oool0oooo00<0oooo
0`3o00050?ooo`030000003oool0oooo00<0oooo0`3o00050?ooo`030000003oool0oooo00<0oooo
0`3o00050?ooo`030000003oool0oooo00<0oooo0`3o00050?ooo`030000003oool0oooo00<0oooo
0`3o00050?ooo`030000003oool0oooo00<0oooo0`3o00050?ooo`030000003oool0oooo00<0oooo
0`3o00050?ooo`030000003oool0oooo00<0oooo0`3o00050?ooo`030000003oool0oooo00<0oooo
0`3o00050?ooo`030000003oool0oooo00<0oooo0`3o00050?ooo`030000003oool0oooo00<0oooo
0`3o00050?ooo`030000003oool0oooo00<0oooo0`3o00050?ooo`030000003oool0oooo00<0oooo
0`3o00050?ooo`030000003oool0oooo00<0oooo0`3o00050?ooo`030000003oool0oooo00<0oooo
0`3o00050?ooo`030000003oool0oooo00<0oooo0`3o00050?ooo`030000003oool0oooo00<0oooo
0`3o00050?ooo`030000003oool0oooo00<0oooo0`3o00050?ooo`030000003oool0oooo00<0oooo
0`3o00050?ooo`030000003oool0oooo00<0oooo0`3o00310?ooo`030000003oool0oooo00@0oooo
00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo
00<000000?ooo`3oool07`3oool002H0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0103oool00`000000oooo0?oo
o`040?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo0<L0oooo00<000000?ooo`3oool0103oool00`000000oooo0?oo
o`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?oo
o`0O0?ooo`009P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool0a`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00`0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo01l0oooo000U0?oo
o`<0o`002`3oool30?l000`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`040?oo
o`030000003oool0oooo00@0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0:0?oo
o`<0o`002`3oool30?l00<P0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0<0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0O0?oo
o`00903oool50?l000T0oooo1@3o000:0?ooo`<0o`00303oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`040?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool02P3oool30?l000X0oooo1@3o00090?ooo`D0
o`00a`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo01l0oooo000T0?ooo`D0o`00
2@3oool50?l000T0oooo1@3o000;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0
103oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`090?ooo`D0o`002@3oool50?l000T0oooo1@3o00370?ooo`<00000
103oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
303oool00`000000oooo0?ooo`0O0?ooo`00903oool50?l000T0oooo1@3o00090?ooo`D0o`002P3o
ool30?l000`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool02P3oool30?l000X0oooo1@3o00090?ooo`D0o`002@3o
ool50?l00<L0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0<0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0O0?ooo`009@3oool3
0?l000/0oooo0`3o000:0?ooo`D0o`002@3oool50?l000/0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02@3oool5
0?l000T0oooo1@3o000:0?ooo`<0o`002`3oool30?l00<P0oooo00<000000?ooo`3oool0103oool0
0`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool0
0`000000oooo0?ooo`0O0?ooo`00@@3oool30?l000X0oooo1@3o000:0?ooo`<0o`00303oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00@0oooo0P0000050?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool02P3oool30?l000X0oooo1@3o000:0?ooo`<0o`00i03oool00`00
0000oooo0?ooo`040?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0<0?ooo`030000003oool0oooo01l0oooo001>0?ooo`D0o`002@3oool50?l000/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`090?ooo`D0o`002@3oool50?l00?40
oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0O0?ooo`00C`3oool30?l000X0oooo
1@3o000:0?ooo`<0o`00303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool02P3oool30?l000X0oooo1@3o000:0?ooo`<0o`00lP3oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0<0?ooo`030000003oool0oooo01l0oooo001L0?ooo`D0o`002@3oool50?l000/0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00T0oooo1@3o
00090?ooo`D0o`00o`3oool3000000@0oooo00<000000?ooo`3oool0303oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool07`3oool005d0oooo0`3o000:
0?ooo`D0o`002`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02@3oool50?l000X0oooo0`3o003o0?ooo`40oooo00<000000?ooo`3oool0103oool0
0`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool0
0`000000oooo0?ooo`0O0?ooo`00JP3oool50?l000/0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0103oool00`00
0000oooo0?ooo`040?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00T0oooo1@3o003o0?ooo`<0oooo00<0omBK0000
000000000`0000000`00Vm@0oooo0?ooo`020?ooo`030000003oool0oooo00@0oooo00<000000?oo
o`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?oo
o`3oool07`3oool006/0oooo0`3o000;0?ooo`<0o`00303oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0:0?ooo`<0
o`002`3oool30?l00?l0oooo1`3oool00`2jLW80^^[o0?ooo`050?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0
oooo00<000000?ooo`3oool07`3oool007P0oooo1@3o000;0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00T0oooo
1@3o003o0?oooa@0oooo00<0^W9b0;[Zo`3oool01@3oool00`000000oooo0?ooo`040?ooo`030000
003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000
003oool0oooo01l0oooo001h0?ooo`D0o`002`3oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`090?ooo`D0o`00o`3o
oolD0?ooo`030;YbLP2jj_l0oooo00D0oooo0`0000040?ooo`030000003oool0oooo00`0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo01l0oooo001h
0?ooo`D0o`002`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`090?ooo`D0o`00o`3oool80?ooo`030;Yb00000000
000000<0000000<007:j0?ooo`3oool00`3oool00`2jLW80^^[o0?ooo`050?ooo`030000003oool0
oooo00@0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00`0oooo00<000000?ooo`3oool07`3oool007T0oooo0`3o000<0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`040?ooo`8000001@3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02P3oool30?l0
0?l0oooo5@3oool00`2jLW80^^[o0?ooo`050?ooo`030000003oool0oooo00@0oooo00<000000?oo
o`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?oo
o`3oool07`3oool008P0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool0o`3ooolR0?ooo`030;YbLP2jj_l0oooo00D0
oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0O0?ooo`00R03oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0103oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`3o0?oooal0oooo00D0j[Yb00000000L[X0^W9b0;[Zo`060?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0
oooo00<000000?ooo`3oool07`3oool008P0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0o`3ooolQ0?ooo`030>Zj
LP000780^^[o00H0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0<0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0O0?ooo`00Q`3o
ool30?l000`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0:0?ooo`<0o`00o`3o
ool[0?ooo`<00000103oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool0303oool00`000000oooo0?ooo`0O0?ooo`00QP3oool50?l000/0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`090?ooo`D0o`00o`3ooolZ0?ooo`030000003oool0
oooo00@0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00`0oooo00<000000?ooo`3oool07`3oool008H0oooo1@3o000;0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool02@3oool50?l00?l0oooo:P3oool00`000000oooo0?ooo`040?oo
o`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?oo
o`030000003oool0oooo01l0oooo00260?ooo`D0o`002`3oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00T0oooo1@3o003o0?ooobX0oooo00<000000?ooo`3oool0103oool00`000000
oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000
oooo0?ooo`0O0?ooo`00Q`3oool30?l000`0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0:0?ooo`<0o`00o`3oool[0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0
303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0
7`3oool009H0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`3o0?ooocP0oooo0`00
00040?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0<0?ooo`030000003oool0oooo01l0oooo002F0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool0103oool2000000D0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`3o
0?ooocP0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0<0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0O0?ooo`00UP3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo0?l0oooo>03oool00`000000oooo0?ooo`040?oo
o`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?oo
o`030000003oool0oooo01l0oooo002F0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool0103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool0o`3ooolh0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0303oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool07`3oool009H0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`3o0?ooocP0oooo00<000000?ooo`3oool0
103oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
303oool00`000000oooo0?ooo`0O0?ooo`00UP3oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo0?l0oooo>03oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00`0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo01l0oooo002F
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`04
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0o`3ooolh0?ooo`<00000103oool0
0`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool0
0`000000oooo0?ooo`0O0?ooo`00UP3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
0?l0oooo>03oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00`0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo01l0oooo002?0?ooo`05
0?oDV`00000000000000002Ke?l00P3oool01P000000oooo0?ooo`3DV`000000002Ke0<0oooo00<0
oooD09/000000000100000000`2Ke?l0oooo0?ooo`020?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`3o0?ooocP0oooo00<000000?ooo`3oool0103o
ool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303o
ool00`000000oooo0?ooo`0O0?ooo`00S`3oool0202jLY/0e?oo0?ooo`3oom@0V`2K0=Coo`3oool0
00000P3oool00`3DV`000000002Ke0040?ooo`070=BK000009/0e?oo0?ooo`000000j[ZK0;[Zo`04
0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`3o
0?ooocP0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0<0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0O0?ooo`00SP3oool00`3o
e9/009_D0?ooo`020?ooo`040>ZjLP1b^^X0oooo000000X0oooo00@0omBK0000LP2jj_l000001P3o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0o`3o
oolh0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0303oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool07`3oool008h0oooo00<0j[Yb
07:jjP3oool00P3oool0103oe9/009_D0?ooo`00000;0?ooo`030?oZ^P1b0000000000H0oooo0`00
00040?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0o`3ooolh0?ooo`<00000103o
ool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303o
ool00`000000oooo0?ooo`0O0?ooo`00SP3oool00`3Z^W80L[[Z0?ooo`020?ooo`030?oDV`00Vm@0
o`000080o`00303oool00`000000L[[Z0?ooo`040?ooo`030000003oool0oooo00@0oooo00<00000
0?ooo`3oool02P3oool30?l00?l0oooo>@3oool00`000000oooo0?ooo`040?ooo`030000003oool0
oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0
oooo01l0oooo002>0?ooo`030>ZjLP1b^^X0oooo0080oooo00<0omBK0?l0003o00000`3o000;0?oo
o`030000002jLY/0e?oo00@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`090?oo
o`D0o`00o`3ooolL0?ooo`050?oDV`00000000000000002Ke?l01@3oool00`3DV`000000002Ke005
0?ooo`050=BK0000000000000000002Ke?l01@3oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003o
ool0oooo01l0oooo002>0?ooo`030?oDV`1b^^X0oooo0080oooo00<0j[Yb0?l0003o00000`3o0007
0?ooo`070>ZjLP2Ke?l0oooo0?ooo`000000e9/009_Do`040?ooo`030000003oool0oooo00@0oooo
00<000000?ooo`3oool02@3oool50?l00?l0oooo703oool01P2jLY/0e?oo0?ooo`3oom@0V`2K0=Co
o`@0oooo00<0e9/000000000Vm@0103oool01`3DV`0009_D0?ooo`3oool0onZj0780002Ke?l0103o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo01l0oooo002?0?ooo`050;Yb002Ke?l0
oooo0?oZ^P1b09/01@3o00070?ooo`070?oDV`0009/0e?oo0?ooo`000000001b0;[Zo`040?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool02@3oool50?l00?l0oooo6`3oool00`3oe9/0
09_D0?ooo`020?ooo`030>ZjLP1b^^X0oooo00l0oooo00<0omBK002Ke03oool00`3oool00`000000
oooo0?ooo`040?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0<0?ooo`030000003oool0oooo01l0oooo002?0?ooo`060?ooe02K000000000000LP2j
j_l0oooo0`3o00090?ooo`050?oDV`00000000000000002jj_l01@3oool00`000000oooo0?ooo`04
0?ooo`030000003oool0oooo00X0oooo0`3o003o0?oooa`0oooo00<0j[Yb07:jjP3oool00P3oool0
0`3oe9/009_D0?ooo`0?0?ooo`030?oDV`00Vm@0oooo00<0oooo00<000000?ooo`3oool0103oool0
0`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool0
0`000000oooo0?ooo`0O0?ooo`00Y03oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo
00@0oooo00<000000?ooo`3oool0o`3ooolP0?ooo`030;Yb00000000000000<0000000D007:j0?oo
o`3oool0j[Yb07:jjP030?ooo`030?oDV`00Vm@0oooo00l0oooo00<0^W8009_Do`3oool00`3oool3
000000@0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00`0oooo00<000000?ooo`3oool07`3oool00:@0oooo00<000000?ooo`3oool0103oool00`00
0000oooo0?ooo`040?ooo`030000003oool0oooo0?l0oooo:@3oool00`3Z^W80L[[Z0?ooo`020?oo
o`030?oDV`00Vm@0oooo00X0oooo00<0oooD09/0000000000P0000000`1b^^X0oooo0?ooo`030?oo
o`030000003oool0oooo00@0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00`0oooo00<000000?ooo`3oool07`3oool00:@0oooo00<000000?ooo`3o
ool0103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0?l0oooo:@3oool00`3oe9/0
L[[Z0?ooo`020?ooo`030>ZjLP1b^^X0oooo00X0oooo00<0oooD09/0V`3Dool0203oool00`000000
oooo0?ooo`040?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0<0?ooo`030000003oool0oooo01l0oooo002T0?ooo`030000003oool0oooo00@0oooo
00<000000?ooo`3oool0103oool00`000000oooo0?ooo`3o0?ooobX0oooo00H0^W8009_Do`3oool0
onZj0780V`3Dool;0?ooo`030?ooe02K09/0e?oo00P0oooo00<000000?ooo`3oool0103oool00`00
0000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`00
0000oooo0?ooo`0O0?ooo`00Y03oool00`000000oooo0?ooo`040?ooo`8000001@3oool00`000000
oooo0?ooo`3o0?ooobX0oooo00D0oooD09/000000000001b0;[Zo`0<0?ooo`030?ooe02K00000000
0080000000<0002K0=Coo`3oool00`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo
00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo
01l0oooo002T0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool00`000000
oooo0?ooo`3o0?ooodH0oooo0`0000040?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo01l0oooo002T0?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`3o0?ooodH0oooo
00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0O0?ooo`00Y03oool00`000000oooo0?oo
o`040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0o`3ooom60?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00`0oooo00<000000?ooo`3oool07`3oool00:@0oooo00<000000?ooo`3oool0103oool0
0`000000oooo0?ooo`040?ooo`030000003oool0oooo0?l0ooooAP3oool00`000000oooo0?ooo`04
0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<
0?ooo`030000003oool0oooo01l0oooo002T0?ooo`030000003oool0oooo00@0oooo00<000000?oo
o`3oool0103oool00`000000oooo0?ooo`3o0?ooodH0oooo00<000000?ooo`3oool0103oool00`00
0000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`00
0000oooo0?ooo`0O0?ooo`00Y03oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`3oool0o`3ooom60?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3o
ool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3o
ool07`3oool00:@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`030000
003oool0oooo0?l0ooooAP3oool3000000@0oooo00<000000?ooo`3oool0303oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool07`3oool00:@0oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0;@0oooo00<0
oooD09/000000000100000001@2Ke?l0oooo0?ooo`3oool0omBK00<0000000<0VmCo0?ooo`3oool0
=@3oool00`3oe9/000000000000300000005002Ke03oool0oooo0?ooo`3oe9/00`0000000`2Ke?l0
oooo0?ooo`0i0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0303oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02P3oool00`3oe9/0
00000000000300000005002Ke03oool0oooo0?ooo`3oe9/00`0000000`2Ke?l000000?ooo`0<0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0:0?oo
o`030?ooe02K0000000000@0000000D0VmCo0?ooo`3oool0oooo0?oDV`030000000309_Do`3oool0
oooo0180oooo002T0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool00`00
0000oooo0?ooo`2e0?ooo`030=BK000009/0e?oo0080oooo00<0j[ZK0;[Zo`3oool00P3oool01P2j
LY/0e?oo0?ooo`3oom@0V`2K0=CoocT0oooo00<0^W9b0;[Zo`3oool0103oool01P2jLY/0e?oo0?oo
o`3oom@0V`2K0=CoocX0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0<0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`04
0000003oool0^W9b0;[Zo`D0oooo00H0^W:K0=Coo`3oool0oooD09/0V`00000=0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030=BK0000
0000e?oo0080oooo00<0j[ZK0;[Zo`3oool00P3oool01P2jLY/0e?oo0?ooo`3oom@0V`2K0=Cooa<0
oooo002T0?ooo`030000003oool0oooo00@0oooo0P0000050?ooo`030000003oool0oooo0;H0oooo
00<0omBK0000LP2jj_l01@3oool00`3oe9/009_D0?ooo`020?ooo`030>ZjLP1b^^X0oooo03P0oooo
00<0^W9b0;[Zo`3oool00`3oool00`3oe9/009_D0?ooo`020?ooo`030>ZjLP1b^^X0oooo03T0oooo
00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`040000003oool0^W9b0;[Zo`@0
oooo00<0omBK002Ke03oool00P3oool00`3Z^W8000000?ooo`0<0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`03000000000780^^[o00D0
oooo00<0omBK002Ke03oool00P3oool00`3Z^W80L[[Z0?ooo`0B0?ooo`00Y03oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0]`3oool00`3oj[X0LP00
07:jjP040?ooo`030>ZjLP1b^^X0oooo0080oooo00<0omBK002Ke03oool0>03oool00`2jLW80^^[o
0?ooo`030?ooo`030>ZjLP1b^^X0oooo0080oooo00<0omBK002Ke03oool0>@3oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00@000000?ooo`2jLW80^^[o103oool00`3Z^W80
L[[Z0?ooo`020?ooo`030?oDV`000000oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00@000000?oZ^P1b0000L[[Z103oool00`3Z
^W80L[[Z0?ooo`020?ooo`030?oDV`00Vm@0oooo0180oooo002T0?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`2/0?ooo`030;Yb00000000000000<0
000000<007:j0?ooo`3oool0103oool00`2jLP00L[[Z0?ooo`020?ooo`030>ZjLP1b^^X0oooo0080
oooo00<0omBK002Ke03oool0;03oool00`2jLP0000000000000300000003001b^P3oool0oooo00<0
oooo00<0^W9b0;[Zo`3oool00`3oool00`3Z^W80L[[Z0?ooo`020?ooo`030?oDV`00Vm@0oooo03T0
oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`040000003oool0^W9b0;[Z
o`@0oooo00<0j[Yb07:jjP3oool00P3oool00`3oe9/000000?ooo`0<0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`050000003oool0oooo
0;Yb001b^^X00`3oool00`3Z^W80L[[Z0?ooo`020?ooo`030?oDV`00Vm@0oooo0180oooo002T0?oo
o`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`2j0?oo
o`060;YbV`3Dool0oooo0?ooo`3Z^W80L[[Z0`3oool00`3oe9/009_D0?ooo`0h0?ooo`030;YbLP2j
j_l0oooo00<0oooo00<0j[Yb07:jjP3oool00P3oool00`3oe9/009_D0?ooo`0i0?ooo`<00000103o
ool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0;0?ooo`040000003oool0^W9b0;[Zo`@0oooo00<0j[Yb07:jjP3oool0
0P3oool00`3oe9/000000?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`0<0?ooo`060000003oool0oooo0?ooo`2jLY/0e?oo0P3oool00`3Z
^W80L[[Z0?ooo`020?ooo`030?oDV`00Vm@0oooo0180oooo002T0?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`2e0?ooo`030>ZjLP2Ke?l0oooo0080
oooo00H0e9/009_Do`3oool0oooo0?oDV`1b^^X30?ooo`030>ZjLP1b^^X0oooo03P0oooo00<0^W9b
0;[Zo`3oool00`3oool00`3oe9/0L[[Z0?ooo`020?ooo`030>ZjLP1b^^X0oooo03T0oooo00<00000
0?ooo`3oool0103oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`040000003oool0^W9b0;[Zo`@0oooo00<0
omBK07:jjP3oool00P3oool00`3Z^W8000000?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030>ZjLP000000oooo0080oooo00H0
e9/009_Do`3oool0oooo0?oDV`1b^^X30?ooo`030>ZjLP1b^^X0oooo0180oooo002T0?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`2e0?ooo`070?oD
V`0009/0e?oo0?ooo`3oe9/0001b0;[Zo`030?ooo`060;Yb002Ke?l0oooo0?oZ^P1b09/0e?oo=P3o
ool01@3Z^W800000001b^P2jLW80^^[o00D0oooo00H0^W8009_Do`3oool0onZj0780V`3Doolj0?oo
o`030000003oool0oooo00@0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02P3oool01@3Z^W800000001b^P2jLW80
^^[o00D0oooo00H0^W8009_Do`3oool0onZj0780V`00000=0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`070?oDV`000000e?oo0?ooo`3o
e9/0001b0;[Zo`030?ooo`060;Yb002Ke?l0oooo0?oZ^P1b09/0e?oo4`3oool00:@0oooo00<00000
0?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0;H0oooo00D0omBK
000000000000001b0;[Zo`040?ooo`050?ooe02K000000000000LP2jj_l0>@3oool00`3Z^W80001b
0;[Zo`050?ooo`050?ooe02K000000000000LP2jj_l0>`3oool00`000000oooo0?ooo`040?ooo`03
0000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00/0oooo00@000000>ZjLP000780^^[o1@3oool01P3oom@0V`00000000000780
^^[o000000d0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00`0oooo0`0000000`000780^^[o0?ooo`030?ooo`050?ooe02K000000000000LP2jj_l0
503oool00:@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo0?l0ooooAP3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00`0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo01l0oooo002T
0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`3o
0?ooodH0oooo0`0000040?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0<0?ooo`030000003oool0oooo01l0oooo002T0?ooo`030000003oool0oooo
00@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`3o0?ooodH0oooo00<000000?oo
o`3oool0103oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool0303oool00`000000oooo0?ooo`0O0?ooo`00Y03oool00`000000oooo0?ooo`040?ooo`80
00001@3oool00`000000oooo0?ooo`3o0?ooodH0oooo00<000000?ooo`3oool0103oool00`000000
oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000
oooo0?ooo`0O0?ooo`00Y03oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo
00<000000?ooo`3oool0o`3ooom60?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0
303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0
7`3oool00:@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo0;L0oooo0`3o000;0?ooo`<0o`002`3oool30?l000/0oooo0`3o000<0?ooo`<0o`002`3o
ool30?l000/0oooo0`3o000;0?ooo`<0o`002`3oool30?l000/0oooo0`3o000;0?ooo`<0o`001@3o
ool00`000000oooo0?ooo`030?ooo`<0o`001P3oool00`000000oooo0?ooo`020?ooo`<0o`001P3o
ool00`000000oooo0?ooo`030?ooo`<0o`001@3oool00`000000oooo0?ooo`030?ooo`<0o`001@3o
ool00`000000oooo0?ooo`030?ooo`<0o`001@3oool00`000000oooo0?ooo`030?ooo`<0o`001@3o
ool00`000000oooo0?ooo`030?ooo`<0o`001@3oool00`000000oooo0?ooo`030?ooo`<0o`001@3o
ool00`000000oooo0?ooo`030?ooo`<0o`001P3oool00`000000oooo0?ooo`020?ooo`<0o`006P3o
ool00:@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`030000003oool0
oooo0;H0oooo1@3o00090?ooo`D0o`002@3oool50?l000T0oooo1@3o000:0?ooo`D0o`002@3oool5
0?l000T0oooo1@3o00090?ooo`D0o`002@3oool50?l000T0oooo1@3o00090?ooo`D0o`00103oool0
0`000000oooo0?ooo`020?ooo`D0o`001@3oool010000000oooo0?ooo`3oool50?l000D0oooo00<0
00000?ooo`3oool00P3oool50?l000@0oooo00<000000?ooo`3oool00P3oool50?l000@0oooo00<0
00000?ooo`3oool00P3oool50?l000@0oooo00<000000?ooo`3oool00P3oool50?l000@0oooo00<0
00000?ooo`3oool00P3oool50?l000@0oooo00<000000?ooo`3oool00P3oool50?l000@0oooo00<0
00000?ooo`3oool00P3oool50?l000D0oooo00@000000?ooo`3oool0oooo1@3o000I0?ooo`00Y03o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0/@3o
ool5000000D0o`002@0000050?l000T000001@3o0009000000D0o`002P0000050?l000T000001@3o
0009000000D0o`002@0000050?l000T000001@3o0009000000D0o`002@0000050?l000T000001@3o
0009000000D0o`002P0000050?l000T000001@3o0009000000D0o`002@0000050?l000T000001@3o
0009000000D0o`002@0000050?l000T000001@3o0006000001<0oooo002T0?ooo`030000003oool0
oooo00@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`2f0?ooo`D0o`00103oool0
0`000000oooo0?ooo`020?ooo`D0o`00103oool00`000000oooo0?ooo`020?ooo`D0o`001@3oool0
10000000oooo0?ooo`3oool50?l000D0oooo00<000000?ooo`3oool00P3oool50?l000@0oooo00<0
00000?ooo`3oool00P3oool50?l000@0oooo00<000000?ooo`3oool00P3oool50?l000@0oooo00<0
00000?ooo`3oool00P3oool50?l000@0oooo00<000000?ooo`3oool00P3oool50?l000@0oooo00<0
00000?ooo`3oool00P3oool50?l000@0oooo00<000000?ooo`3oool00P3oool50?l000T0oooo1@3o
00090?ooo`D0o`002P3oool50?l000T0oooo1@3o00090?ooo`D0o`002@3oool50?l000T0oooo1@3o
00090?ooo`D0o`002@3oool50?l000T0oooo1@3o000I0?ooo`00Y03oool00`000000oooo0?ooo`04
0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0]`3oool30?l000D0oooo00<00000
0?ooo`3oool00`3oool30?l000D0oooo00<000000?ooo`3oool00`3oool30?l000H0oooo00<00000
0?ooo`3oool00P3oool30?l000H0oooo00<000000?ooo`3oool00`3oool30?l000D0oooo00<00000
0?ooo`3oool00`3oool30?l000D0oooo00<000000?ooo`3oool00`3oool30?l000D0oooo00<00000
0?ooo`3oool00`3oool30?l000D0oooo00<000000?ooo`3oool00`3oool30?l000D0oooo00<00000
0?ooo`3oool00`3oool30?l000D0oooo00<000000?ooo`3oool00`3oool30?l000/0oooo0`3o000;
0?ooo`<0o`00303oool30?l000/0oooo0`3o000;0?ooo`<0o`002`3oool30?l000/0oooo0`3o000;
0?ooo`<0o`002`3oool30?l000/0oooo0`3o000J0?ooo`00S`3oool01@3oe9/00000000000000000
VmCo00D0oooo00<0e9/000000000Vm@01P3oool01@3oj[X0LP00000000000000VmCo00@0oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`2o0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool0YP3oool008l0oooo00H0^W:K0=Coo`3oool0oooD09/0V`3Dool40?ooo`030=BK
0000000009_D00P0oooo00<0000009_Do`3oool0103oool00`000000oooo0?ooo`040?ooo`030000
003oool0oooo0;l0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`2V0?ooo`00SP3o
ool00`3oe9/009_D0?ooo`020?ooo`030>ZjLP1b^^X0oooo00h0oooo00<0000009_Do`3oool0103o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0;l0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0103o
ool300000:H0oooo002>0?ooo`030>ZjLP1b^^X0oooo0080oooo00<0omBK002Ke03oool02P3oool0
0`3Z^W800000000000030000000309_Do`3oool0oooo0080oooo0`0000040?ooo`030000003oool0
oooo0;l0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`2V0?ooo`00SP3oool00`3Z
^W80L[[Z0?ooo`020?ooo`030?oDV`00Vm@0oooo00X0oooo00H0omBK0000V`3Dool0oooo0000002K
e?l50?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0_`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`040?ooo`030000003oool0oooo0:H0oooo002>0?ooo`030>ZjLP1b^^X0oooo0080oooo00<0omBK
002Ke03oool02`3oool01@3Z^W8009_D0?ooo`000000VmCo00D0oooo00<000000?ooo`3oool0103o
ool00`000000oooo0?ooo`2o0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0YP3o
ool008h0oooo00<0omBK07:jjP3oool00P3oool00`3Z^W80L[[Z0?ooo`0<0?ooo`040;Yb001b^^X0
000009_Do`D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`2o0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool0YP3oool008l0oooo00H0^W8009_Do`3oool0onZj0780
V`3Dool=0?ooo`040?oZ^P1b0780000009_Do`D0oooo00<000000?ooo`3oool0103oool00`000000
oooo0?ooo`2o0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0YP3oool008l0oooo
00D0oooD09/000000000001b0;[Zo`0?0?ooo`030?oDV`000000VmCo00D0oooo00<000000?ooo`3o
ool0103oool00`000000oooo0?ooo`2o0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00@0oooo0`00002V0?ooo`00
Y03oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0
_`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0:H0oooo002T0?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`2o0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool0YP3oool00:@0oooo00<000000?ooo`3oool0103oool0
0`000000oooo0?ooo`040?ooo`030000003oool0oooo0;l0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0103oool0
0`000000oooo0?ooo`2V0?ooo`00Y03oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo
00@0oooo00<000000?ooo`3oool0_`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo
0:H0oooo002T0?ooo`030000003oool0oooo00@0oooo0P0000050?ooo`030000003oool0oooo0;l0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool0103oool300000:H0oooo002T0?ooo`030000003oool0oooo00@0oooo
00<000000?ooo`3oool0103oool00`000000oooo0?ooo`2o0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00@0oooo
00<000000?ooo`3oool0YP3oool00:@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?oo
o`040?ooo`030000003oool0oooo0;l0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0103oool00`000000oooo0?oo
o`2V0?ooo`00Y03oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo00<00000
0?ooo`3oool0_`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0:H0oooo002T0?oo
o`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`2o0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00@0oooo00<000000?ooo`3oool0YP3oool00:@0oooo00<000000?ooo`3o
ool0103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0;l0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool0103oool00`000000oooo0?ooo`2V0?ooo`00Y03oool00`000000oooo0?ooo`040?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`3oool0_`3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`040?ooo`<00000
YP3oool00:@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo0;l0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`2V0?ooo`00Y03oool0
0`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0_`3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00@0oooo00D0omBK000000000000000009_D
o`020?ooo`060000003oool0oooo0=BK0000000009_D1@3oool01@3DV`000000000000000000VmCo
00D0oooo00<000000?ooo`3oool0YP3oool00:@0oooo00<000000?ooo`3oool0103oool00`000000
oooo0?ooo`040?ooo`030000003oool0oooo0;l0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`040?ooo`080;YbV`3Dool0oooo0?ooe02K09/0e?oo0?ooo`0000020?ooo`030=BK0000
000009_D00@0oooo00L0e9/0002Ke03oool0oooo0000001b0000VmCo00@0oooo00<000000?ooo`3o
ool0YP3oool00:@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`030000
003oool0oooo0;l0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`030?ooo`030?oD
V`00Vm@0oooo0080oooo00@0j[Yb07:jjP3oool000003@3oool00`000000omBK002Ke0040?ooo`03
0000003oool0oooo0:H0oooo002T0?ooo`030000003oool0oooo00@0oooo0P0000050?ooo`030000
003oool0oooo0;l0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`030?ooo`030>Zj
LP1b^^X0oooo0080oooo00@0omBK002Ke03oool000003@3oool00`000000omBK002Ke0040?ooo`<0
0000YP3oool00:@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`030000
003oool0oooo0;l0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`030?ooo`030>Zj
LP1b^^X0oooo0080oooo00@0omBK002Ke03oool000003@3oool00`000000^W8009_Do`040?ooo`03
0000003oool0oooo0:H0oooo002T0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0
103oool00`000000oooo0?ooo`2o0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
0`3oool00`3Z^W80L[[Z0?ooo`020?ooo`040?oDV`00Vm@0oooo000000T0oooo00<0oooD09/00000
00000P0000000`1b^^X0oooo0?ooo`030?ooo`030000003oool0oooo0:H0oooo002T0?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`2o0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool00`3oool00`3oe9/0L[[Z0?ooo`020?ooo`040>Zj
LP1b^^X0oooo000000T0oooo00D0oooD09/0V`3Dool0oooo000000060?ooo`030000003oool0oooo
0:H0oooo002T0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool00`000000
oooo0?ooo`2o0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0103oool0202jLP00
VmCo0?ooo`3oj[X0LP2K0=Coo`3oool000002@3oool01@3oom@0V`2K0=Coo`3oool0000000H0oooo
00<000000?ooo`3oool0YP3oool00:@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?oo
o`040?ooo`030000003oool0oooo0;l0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`040?ooo`050?ooe02K000000000000LP2jj_l00P3oool00`000000oooo0?ooo`070?ooo`030?oo
e02K000000000080000000<0002K0=Coo`3oool00`3oool00`000000oooo0?ooo`2V0?ooo`00Y03o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0_`3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`040?ooo`<00000YP3oool00:@0oooo00<000000?ooo`3oool0103oool0
0`000000oooo0?ooo`040?ooo`030000003oool0oooo0;l0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0103oool0
0`000000oooo0?ooo`2V0?ooo`00Y03oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo
00@0oooo00<000000?ooo`3oool0_`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo
0:H0oooo002T0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool00`000000
oooo0?ooo`2o0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0YP3oool00:@0oooo
00<000000?ooo`3oool0103oool2000000D0oooo00<000000?ooo`3oool0_`3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo0:H0oooo002T0?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`2o0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool0YP3oool00:@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`04
0?ooo`030000003oool0oooo0;l0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0103oool300000:H0oooo002T0?oo
o`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`2o0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00@0oooo00<000000?ooo`3oool0YP3oool00:@0oooo00<000000?ooo`3o
ool0103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0;l0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool0103oool00`000000oooo0?ooo`2V0?ooo`00Y03oool00`000000oooo0?ooo`040?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`3oool0_`3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`040?ooo`030000
003oool0oooo0:H0oooo002?0?ooo`050?oDV`00000000000000002Ke?l01@3oool00`3DV`000000
002Ke0060?ooo`050=BK0000000000000000V`3Dool0103oool00`000000oooo0?ooo`040?ooo`03
0000003oool0oooo0;l0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`2V0?ooo`00
S`3oool01P2jLY/0e?oo0?ooo`3oom@0V`2K0=Coo`@0oooo00<0e9/000000000Vm@01@3oool01P3Z
^W8009_D0?ooo`000000omBK002Ke0@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?oo
o`2o0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00@0oooo0`00002V0?ooo`00SP3oool00`3oe9/009_D0?ooo`02
0?ooo`030>ZjLP1b^^X0oooo00X0oooo00L0oooD09/0002Ke?l0oooo0000003oom@0Vg:j00@0oooo
00<000000?ooo`3oool0103oool00`000000oooo0?ooo`2o0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00@0oooo
00<000000?ooo`3oool0YP3oool008h0oooo00<0j[Yb07:jjP3oool00P3oool00`3oe9/009_D0?oo
o`0:0?ooo`070?oDV`00LW80V`2K0=Coo`000000j[Yb002Ke0040?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`3oool0_`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0:H0
oooo002>0?ooo`030>ZjLP1b^^X0oooo0080oooo00<0omBK002Ke03oool02P3oool00`3oj[X0LW:j
0?oDV`0200000003001b^P3oool0oooo00<0oooo0`0000040?ooo`030000003oool0oooo0;l0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool0103oool00`000000oooo0?ooo`2V0?ooo`00SP3oool00`3Z^W80L[[Z0?oo
o`020?ooo`030?oDV`00Vm@0oooo00X0oooo00D0oooD09/0V`3Dool0oooo000000060?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`3oool0_`3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`040?ooo`030000
003oool0oooo0:H0oooo002>0?ooo`030?oDV`1b^^X0oooo0080oooo00<0j[Yb07:jjP3oool02`3o
ool0103DV`00L[[Z0?ooo`0000060?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0
_`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0:H0oooo002?0?ooo`060;Yb002K
e?l0oooo0?oZ^P1b09/0e?oo303oool0103oom@0V`00002Ke00000060?ooo`030000003oool0oooo
00@0oooo00<000000?ooo`3oool0_`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`040?ooo`<00000YP3oool008l0
oooo00D0oooD09/000000000001b0;[Zo`0?0?ooo`040=BK000000000000001b^P@0oooo00<00000
0?ooo`3oool0103oool00`000000oooo0?ooo`2o0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00@0oooo00<00000
0?ooo`3oool0YP3oool00:<0oooo0`3o00050?ooo`030000003oool0oooo00<0oooo0`3o00300?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`070?oo
o`030?oDV`000000000000<0000000<009_D0?ooo`3oool00P3oool00`000000oooo0?ooo`2V0?oo
o`00XP3oool50?l000@0oooo00<000000?ooo`3oool00P3oool50?l00;l0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00X0oooo00<0^W9b0000003o
ool01@3oool00`000000oooo0?ooo`2V0?ooo`00XP3oool50?l000@0oooo00<000000?ooo`3oool0
0P3oool50?l00;l0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00X0oooo00<0^W9b0000003oool01@3oool00`000000oooo0?ooo`2V0?ooo`00XP3o
ool50?l000@0oooo00<000000?ooo`3oool00P3oool50?l00;l0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00X0oooo00<0^W9b0000003oool01@3o
ool300000:H0oooo002S0?ooo`<0o`001@3oool00`000000oooo0?ooo`030?ooo`<0o`00`03oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02P3oool0
0`2jLW8000000?ooo`050?ooo`030000003oool0oooo0:H0oooo002[0?ooo`800000a`3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02P3oool00`2j
LW8000000?ooo`050?ooo`030000003oool0oooo0:H0oooo002[0?ooo`030000003oool0oooo0<H0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00X0
oooo00<0^W9b0000003oool01@3oool00`000000oooo0?ooo`2V0?ooo`00Z`3oool00`000000oooo
0?ooo`360?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`070?ooo`050>ZjLP00000007:j0;YbLP0000001P3oool00`000000oooo0?ooo`2V0?ooo`00
Z`3oool00`000000oooo0?ooo`360?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`090?ooo`030>ZjLP000780000000H0oooo00<000000?ooo`3oool0
YP3oool00:/0oooo00<000000?ooo`3oool0aP3oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`040?ooo`<00000YP3o
ool00:/0oooo00<000000?ooo`3oool0aP3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`040?ooo`030000003oool0
oooo0:H0oooo002[0?ooo`030000003oool0oooo0<H0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0103oool00`00
0000oooo0?ooo`2V0?ooo`00Z`3oool00`000000oooo0?ooo`360?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`3oool0YP3oool00:/0oooo00<000000?ooo`3oool0aP3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo0:H0oooo002[0?ooo`030000003oool0oooo0<H0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool0103oool300000:H0oooo002[0?ooo`800000a`3oool00`000000oooo0?ooo`0;
0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`04
0?ooo`030000003oool0oooo0:H0oooo002[0?ooo`030000003oool0oooo0<H0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool0103oool00`000000oooo0?ooo`2V0?ooo`00Z`3oool00`000000oooo0?ooo`360?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool0YP3oool00:/0oooo00<000000?ooo`3oool0
aP3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0:H0oooo002[0?ooo`030000003o
ool0oooo0<H0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`2V0?ooo`00Z`3oool0
0`000000oooo0?ooo`360?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00@0oooo0`00002V0?ooo`00Z`3oool00`00
0000oooo0?ooo`360?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0YP3oool00:/0
oooo00<000000?ooo`3oool0aP3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0:H0
oooo002[0?ooo`030000003oool0oooo0<H0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0103oool00`000000oooo
0?ooo`2V0?ooo`00Z`3oool00`000000oooo0?ooo`360?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool0YP3oool00:/0oooo0P0000370?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00@0oooo0`00002V
0?ooo`00Z`3oool00`000000oooo0?ooo`360?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00@0oooo00<000000?oo
o`3oool0YP3oool00:/0oooo00<000000?ooo`3oool0aP3oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00<0oooo00<0omBK0000000000000`0000000`00Vm@0oooo000000020?ooo`03
0=BK0000000009_D00D0oooo00D0e9/0000000000000000009_Do`050?ooo`030000003oool0oooo
0:H0oooo002[0?ooo`030000003oool0oooo0<H0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`060?ooo`030;YbLP2jj_l0oooo0080oooo00H000000?ooo`3oool0e9/000000000Vm@4
0?ooo`070=BK0000Vm@0oooo0?ooo`000000LP0009_Do`040?ooo`030000003oool0oooo0:H0oooo
002[0?ooo`030000003oool0oooo0<H0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`060?ooo`030;YbLP2jj_l0oooo0080oooo00<000000?ooo`3oool02`3oool00`000000omBK002K
e0040?ooo`030000003oool0oooo0:H0oooo002[0?ooo`030000003oool0oooo0<H0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`060?ooo`030;YbLP2jj_l0oooo0080oooo00<00000
0?ooo`3oool02`3oool00`000000omBK002Ke0040?ooo`030000003oool0oooo0:H0oooo002[0?oo
o`030000003oool0oooo0<H0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`060?oo
o`030;YbLP2jj_l0oooo0080oooo00<000000?ooo`3oool02`3oool00`000000^W8009_Do`040?oo
o`<00000YP3oool008l0oooo00D0omBK000000000000000009_Do`050?ooo`030=BK0000000009_D
00D0oooo00D0e9/00000000000000000002Ke0050?ooo`030000003oool0oooo0<H0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`060?ooo`030;YbLP2jj_l0oooo0080oooo00<00000
0?ooo`3oool01`3oool00`3oom@0V`00000000020000000307:jjP3oool0oooo00<0oooo00<00000
0?ooo`3oool0YP3oool008l0oooo00H0^W:K0=Coo`3oool0oooD09/0V`3Dool40?ooo`030=BK0000
000009_D00@0oooo00<0omBK002Ke03oool00P3oool00`3DVg80^^[o0?ooo`030?ooo`030000003o
ool0oooo0<D0oooo0`3o000;0?ooo`<0o`002`3oool30?l000`0oooo0`3o000;0?ooo`<0o`002`3o
ool30?l000/0oooo0`3o000;0?ooo`<0o`001`3oool0102jLW80^^[o0?ooo`3oool30?l000P0oooo
00<0oooD09/0V`3Dool00`3o00050?ooo`030000003oool0oooo0:H0oooo002>0?ooo`030?oDV`00
Vm@0oooo0080oooo00<0j[Yb07:jjP3oool02P3oool00`3Z^W80L[[Z0?ooo`020?ooo`030=BK002K
e?l0oooo00<0oooo00<000000?ooo`3oool0a03oool50?l000T0oooo1@3o00090?ooo`D0o`002P3o
ool50?l000T0oooo1@3o00090?ooo`D0o`002@3oool50?l000T0oooo1@3o00030?ooo`060>ZjLP00
000007:j0;YbLP2jj_l0oooo1@3o00070?ooo`030?ooe02K09/0o`0000@0o`00103oool00`000000
oooo0?ooo`2V0?ooo`00SP3oool00`3Z^W80L[[Z0?ooo`020?ooo`030?oDV`00Vm@0oooo00X0oooo
00<0omBK001b^P3oool00P3oool00`2jLW80^^[o0?ooo`030?ooo`<00000a03oool50?l000T0oooo
1@3o00090?ooo`D0o`002P3oool50?l000T0oooo1@3o00090?ooo`D0o`002@3oool50?l000T0oooo
1@3o00050?ooo`040>ZjLP000780^^[o0?ooo`D0o`001`3oool00`3oom@0V`000?l000040?l000@0
oooo00<000000?ooo`3oool0YP3oool008h0oooo00<0j[Yb07:jjP3oool00P3oool00`3oe9/009_D
0?ooo`0;0?ooo`050>ZjLP00000000000000001b^^X0c03oool50?l000T0oooo1@3o00090?ooo`D0
o`002P3oool50?l000T0oooo1@3o00090?ooo`D0o`002@3oool50?l000T0oooo1@3o00090?ooo`D0
o`002@3oool50?l000@0oooo0`00002V0?ooo`00SP3oool00`3Z^W80L[[Z0?ooo`020?ooo`030?oD
V`00Vm@0oooo00X0oooo00<0oooD09]b^P3oool00P3oool00`2jLY/0e?oo0?ooo`3;0?ooo`<0o`00
2`3oool30?l000/0oooo0`3o000<0?ooo`<0o`002`3oool30?l000/0oooo0`3o000;0?ooo`<0o`00
2`3oool30?l000/0oooo0`3o000;0?ooo`<0o`001@3oool00`000000oooo0?ooo`2V0?ooo`00SP3o
ool00`3oe9/0L[[Z0?ooo`020?ooo`030>ZjLP1b^^X0oooo00X0oooo00<0omBK07:jjP3oool00P3o
ool00`3DV`00VmCo0?ooo`3o0?oooe<0oooo00<000000?ooo`3oool0YP3oool008l0oooo00H0^W80
09_Do`3oool0onZj0780V`3Dool;0?ooo`070?oZ^P1b09/0e?oo0?ooo`3oj[X0LP2K0=Coo`3o0?oo
oe@0oooo00<000000?ooo`3oool0YP3oool008l0oooo00D0oooD09/000000000001b0;[Zo`0=0?oo
o`050?oDV`00000000000000LP2jj_l0o`3oooon0?ooo`00o`3ooooo0?ooojD0oooo003o0?ooool0
ooooY@3oool00?l0ooooo`3ooonU0?ooo`00o`3ooooo0?ooojD0oooo003o0?ooool0ooooY@3oool0
0?l0ooooo`3ooonU0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 674.25}, {197.75, 0}} -> {-0.0536306, -0.0147182, \
0.00468802, 0.00468802}, {{17.125, 321.875}, {193, 4.6875}} -> {-24.5547, \
-0.12355, 0.214451, 0.00743549}, {{352.313, 657.063}, {193, 4.6875}} -> \
{-71.8431, -1.78129, 0.21258, 0.0270147}}],

Cell[TextData[{
  StyleBox["Sugerencias",
    FontWeight->"Bold"],
  ". Usa en lo que sigue las notaciones a[k], b[k],c[k] para los coeficientes \
respectivos. Aveces no es posible sustituir k por 0 (y puede que para algunos \
otros valores) para obtener los valores a[0],b[0] o c[0]. Cuando esto ocurra \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " dar\[AAcute] un mensaje de error diciendo que ha encontrado la expresi\
\[OAcute]n 1/0. En tales casos lo mejor es definir directamente esos valores \
(a[0]=A[f,0,{a,b}], a[1]=A[f,1,{a,b}],b[1]=B[f,1,{a,b}]...). No olvides que \
b[0]=0 por lo que siempre puedes definirlo as\[IAcute]. Para calcular los \
coeficientes de una se\[NTilde]al deber\[AAcute]s definir funciones a[k_], \
b[k_] o c[k_]. Puede ser conveniente usar la asignaci\[OAcute]n directa en \
las definiciones, pues de esta forma tenemos calculados todos los \
coeficientes de golpe con una sola integraci\[OAcute]n. Si usas la asignaci\
\[OAcute]n diferida, cada vez que llames a los coeficientes deber\[AAcute] \
realizarse la integraci\[OAcute]n correspondiente. Naturalmente, esto se \
refiere a los c\[AAcute]lculos simb\[OAcute]licos, en los c\[AAcute]lculos \
num\[EAcute]ricos debes usar siempre la asignaci\[OAcute]n diferida. Cuando \
pases de un ejercicio al siguiente no olvides limpiar todo lo que pueda \
molestar; al menos un \"Clear[a,b,c]\" parece necesario."
}], "Text"],

Cell[CellGroupData[{

Cell["Ejercicio 1", "Exercise"],

Cell[TextData[{
  "a) Calcula de forma simb\[OAcute]lica los coeficientes seno y coseno de la \
funci\[OAcute]n  de per\[IAcute]odo 1 que es igual a ",
  StyleBox["t",
    FontSlant->"Italic"],
  " para ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] t < 1\)]],
  ". Haz una animaci\[OAcute]n en la que aparezca la grafica de la funci\
\[OAcute]n y las gr\[AAcute]ficas de sus polinomios de Fourier de \
\[OAcute]rdenes 2k-1 para ",
  Cell[BoxData[
      \(TraditionalForm\`1 \[LessEqual] k \[LessEqual] 10\)]],
  " en el intervalo [-2,2]. \nb) Representa gr\[AAcute]ficamente el espectro \
de amplitudes y el espectro de fases correspondiente a los coeficientes ",
  Cell[BoxData[
      \(TraditionalForm\`c\_n\)]],
  " de la funci\[OAcute]n considerada en el apartado a) para ",
  Cell[BoxData[
      \(TraditionalForm\`\(-19\) \[LessEqual] n \[LessEqual] 19\)]],
  ". "
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 2", "Exercise"],

Cell[TextData[{
  "Calcula de forma simb\[OAcute]lica los coeficientes de Fourier seno y \
coseno de la funci\[OAcute]n \"onda cuadrada\" de per\[IAcute]odo 1 que toma \
el valor -1 para ",
  Cell[BoxData[
      \(TraditionalForm\`\(-1\)/2 \[LessEqual] t < 0\)]],
  " y toma el valor 1 para ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] t < 1/2\)]],
  ". Haz una animaci\[OAcute]n en la que aparezca la grafica de la funci\
\[OAcute]n y las gr\[AAcute]ficas de sus polinomios de Fourier de \
\[OAcute]rdenes 2k-1 para ",
  Cell[BoxData[
      \(TraditionalForm\`1 \[LessEqual] k \[LessEqual] 10\)]],
  " en el intervalo [-3/2,3/2]."
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 3", "Exercise"],

Cell[TextData[{
  "En este ejercicio se considera la extensi\[OAcute]n peri\[OAcute]dica de \
una funci\[OAcute]n ",
  StyleBox["f ",
    FontSlant->"Italic"],
  "en un intervalo ",
  Cell[BoxData[
      \(TraditionalForm\`\([c, d]\)\)]],
  ".",
  StyleBox["\na)",
    FontWeight->"Bold"],
  " Define funciones A[f_,n_,{c_,d_}] y B[f_,n_,{c_,d_}] que calculen simb\
\[OAcute]licamente los coeficientes seno y coseno n-\[EAcute]simos de ",
  StyleBox["f",
    FontSlant->"Italic"],
  ". \n",
  StyleBox["b)",
    FontWeight->"Bold"],
  " Define funciones NA[f_,n_,{c_,d_}] y NB[f_,n_,{c_,d_}] que calculen num\
\[EAcute]ricamente los coeficientes seno y coseno n-\[EAcute]simos de ",
  StyleBox["f.",
    FontSlant->"Italic"],
  "\n",
  StyleBox["c)",
    FontWeight->"Bold"],
  " Define una funci\[OAcute]n  PoliFourier[f_,N_,{c_,d_}][t_] que calcule \
simb\[OAcute]licamente el polinomio de fourier de orden N de ",
  StyleBox["f",
    FontSlant->"Italic"],
  ".\n",
  StyleBox["d)",
    FontWeight->"Bold"],
  " Define una funci\[OAcute]n  NPoliFourier[f_,N_,{c_,d_}][t_] que calcule \
num\[EAcute]ricamente el polinomio de fourier de orden N de ",
  StyleBox["f",
    FontSlant->"Italic"],
  ". \nSugerencias. Si defines estos comandos de la forma natural, para que \
funcionen debes llamar a la funci\[OAcute]n \" f \" por su nombre, f,  y no \
f[x]. En ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 5 puedes usar el comando Integrate[f[t],{t,a,b},Assumptions\[Rule]n\
\[Element]Integers] que simplifica el resultado suponiendo que ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " es un entero. Si vas a usar los comandos simb\[OAcute]licos para calcular \
tablas de polinomios de Fourier es \[UAcute]til que los definas usando la \
asignaci\[OAcute]n inmediata pues de esta forma tenemos calculados todos los \
coeficientes de golpe con una sola integraci\[OAcute]n. Para el apartado b) \
es muy conveniente usar las opciones AccuracyGoal",
  Cell[BoxData[
      \(TraditionalForm\` -> \)]],
  "4  y el comando Chop (consulta la ayuda de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "). Si vas a usar los comandos num\[EAcute]ricos para calcular tablas de \
polinomios de Fourier es \[UAcute]til que los definas de forma que almacenen \
los resultados que vayan calculando (esto lleva consigo la obligaci\[OAcute]n \
de hacer un Clear[NA,NB] cuando quieras cambiar de funci\[OAcute]n).\n\
Observaci\[OAcute]n. No creas que los comandos as\[IAcute] definidos van a \
calcular los coeficientes de Fourier de cualquier funci\[OAcute]n. Por \
supuesto, s\[OAcute]lo podr\[AAcute]n calcularse los coeficientes de forma \
simb\[OAcute]lica para funciones sencillas para que las correspondientes \
integrales puedan evaluarse simb\[OAcute]licamente. Pero incluso los comandos \
num\[EAcute]ricos, cuando una funci\[OAcute]n est\[AAcute] definida a trozos \
o se hace infinita en alg\[UAcute]n punto o bien oscila mucho, es posible que \
tengas que retocarlos para esa funci\[OAcute]n concreta."
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 4", "Exercise"],

Cell[TextData[{
  "a",
  StyleBox[")",
    FontWeight->"Bold"],
  " Utiliza las funciones definidas en el ejercicio anterior para calcular \
simb\[OAcute]licamente (simplific\[AAcute]ndolos) los coeficientes seno y \
coseno de la funci\[OAcute]n de per\[IAcute]odo 2 que es igual a ",
  Cell[BoxData[
      \(TraditionalForm\`t\ \(sen(\[Pi]\ t)\)\)]],
  " en el intervalo ",
  Cell[BoxData[
      \(TraditionalForm\`\([\(-1\), 1]\)\)]],
  ". Calcula sus primeros 10 polinomios de Fourier y repres\[EAcute]ntalos gr\
\[AAcute]ficamente junto con la funci\[OAcute]n en el intervalo [-3,3].\nb",
  StyleBox[") ",
    FontWeight->"Bold"],
  "Utiliza las funciones definidas en el ejercicio anterior para calcular num\
\[EAcute]ricamente los  primeros 10 polinomios de Fourier  de la funci\
\[OAcute]n de per\[IAcute]odo 2\[Pi] que es igual a ",
  Cell[BoxData[
      \(TraditionalForm\`Sin[t\^2]\)]],
  " en el intervalo",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\([\(-\[Pi]\), \[Pi]]\)\)\)]],
  " y repres\[EAcute]ntalos gr\[AAcute]ficamente junto con la funci\[OAcute]n \
en el intervalo ",
  Cell[BoxData[
      \(TraditionalForm\`\([\(-3\) \[Pi], 3  \[Pi]]\)\)]],
  "."
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 5", "Exercise"],

Cell[TextData[{
  "En este ejercicio se considera la extensi\[OAcute]n peri\[OAcute]dica de \
una funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " en un intervalo [a,b]\n",
  StyleBox["a)",
    FontWeight->"Bold"],
  " Define una funci\[OAcute]n c[f_,n_,{var_,a_,b_}] que calcule \
simb\[OAcute]licamente los coeficientes de Fourier de ",
  StyleBox["f",
    FontSlant->"Italic"],
  ".\n",
  StyleBox["b)",
    FontWeight->"Bold"],
  " Define una funci\[OAcute]n Nc[f_,n_,{var_,a_,b_}] que calcule \
num\[EAcute]ricamente los coeficientes de Fourier de ",
  StyleBox["f",
    FontSlant->"Italic"],
  ".\n",
  StyleBox["c)",
    FontWeight->"Bold"],
  " Define una funci\[OAcute]n ComplexPoliFourier[f_,N_,{t_,a_,b_}] que \
calcule simb\[OAcute]licamente el polinomio de Fourier con coeficientes \
complejos de orden N de ",
  StyleBox["f",
    FontSlant->"Italic"],
  ".\n",
  StyleBox["d)",
    FontWeight->"Bold"],
  " Define una funci\[OAcute]n NComplexPoliFourier[f_,N_,{t_,a_,b_}] que \
calcule num\[EAcute]ricamente el polinomio de Fourier con coeficientes \
complejos de orden N de ",
  StyleBox["f",
    FontSlant->"Italic"],
  ".\n",
  StyleBox["e)",
    FontWeight->"Bold"],
  " Calcula simb\[OAcute]licamente los coeficientes de Fourier de las \
funciones: ",
  Cell[BoxData[
      \(TraditionalForm\`1 - t\^2\)]],
  " para ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] t \[LessEqual] 1\)]],
  ";  ",
  Cell[BoxData[
      \(TraditionalForm\`\[Pi]\^2/4 - \((Abs[t] - \[Pi]/2)\)\^2\)]],
  " para ",
  Cell[BoxData[
      \(TraditionalForm\`\(-\[Pi]\) \[LessEqual] t \[LessEqual] \[Pi]\)]],
  ".\n",
  StyleBox["f) ",
    FontWeight->"Bold"],
  "Calcula num\[EAcute]ricamente el polinomio de Fourier de orden 20 con \
coeficientes complejos de la funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`Cos[t\^2]\)]],
  " en el intervalo",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\([\(-\[Pi]\), \[Pi]]\)\)\)]],
  ".\nObservaciones / Sugerencias: las mismas que para el ejercicio 3."
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 6", "Exercise"],

Cell[TextData[{
  StyleBox["a)",
    FontWeight->"Bold"],
  " Define la extensi\[OAcute]n par y la extensi\[OAcute]n impar de ",
  Cell[BoxData[
      \(TraditionalForm\`f(x) = 1 - x\^2\)]],
  " para ",
  Cell[BoxData[
      \(TraditionalForm\`x \[Element] \([0, 1]\)\)]],
  ". Repres\[EAcute]ntalas gr\[AAcute]ficamente.\n",
  StyleBox["b)",
    FontWeight->"Bold"],
  " Calcula los primeros 10 polinomios de las series de Fourier seno y coseno \
de ",
  StyleBox["f. \n",
    FontSlant->"Italic"],
  StyleBox["c)",
    FontWeight->"Bold"],
  StyleBox[" ",
    FontSlant->"Italic"],
  "Haz una animaci\[OAcute]n gr\[AAcute]fica representando la gr\[AAcute]fica \
de ",
  StyleBox["f ",
    FontSlant->"Italic"],
  " y sus primeros 10 polinomios seno en el intervalo [0,1].\n",
  StyleBox["d) ",
    FontWeight->"Bold"],
  "Haz una animaci\[OAcute]n gr\[AAcute]fica representando la gr\[AAcute]fica \
de ",
  StyleBox["f ",
    FontSlant->"Italic"],
  " y sus primeros 10 polinomios coseno en el intervalo [0,1].\n",
  StyleBox[" ",
    FontSlant->"Italic"],
  StyleBox["e)",
    FontWeight->"Bold"],
  StyleBox[" ",
    FontSlant->"Italic"],
  "\[DownQuestion]Cu\[AAcute]l de las dos series aproxima mejor a ",
  StyleBox["f ",
    FontSlant->"Italic"],
  "?"
}], "ExerciseText"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 685}},
AutoGeneratedPackage->None,
WindowSize->{1016, 651},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification->1,
StyleDefinitions -> "Classroom.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 34, 0, 67, "Title"],
Cell[1791, 53, 204, 3, 75, "Author"],

Cell[CellGroupData[{
Cell[2020, 60, 39, 0, 62, "Section"],
Cell[2062, 62, 287, 11, 29, "Text"],
Cell[2352, 75, 233, 5, 42, "Text"],
Cell[2588, 82, 415, 19, 29, "Text"],
Cell[3006, 103, 1752, 51, 48, "Text"],
Cell[4761, 156, 74, 0, 29, "Text"],
Cell[4838, 158, 168, 3, 41, "Text"],
Cell[5009, 163, 328, 14, 29, "Text"],
Cell[5340, 179, 811, 23, 48, "Text"],
Cell[6154, 204, 34, 0, 29, "Text"],
Cell[6191, 206, 1624, 47, 55, "Text"],
Cell[7818, 255, 168, 7, 29, "Text"],
Cell[7989, 264, 1463, 31, 105, "Text"],
Cell[9455, 297, 925, 22, 96, "Text"],
Cell[10383, 321, 3671, 77, 446, "Input"],
Cell[14057, 400, 157, 3, 44, "Text"],
Cell[14217, 405, 237, 4, 113, "Input"],
Cell[14457, 411, 187, 5, 27, "Text"],
Cell[14647, 418, 724, 12, 134, "Input"],
Cell[15374, 432, 217, 4, 44, "Text"],
Cell[15594, 438, 441, 7, 62, "Text"],
Cell[16038, 447, 206, 4, 44, "Text"],
Cell[16247, 453, 427, 11, 38, "Text"],
Cell[16677, 466, 1096, 30, 79, "Text"],
Cell[17776, 498, 96950, 1844, 140, 10243, 769, "GraphicsData", "PostScript", \
"Graphics"],
Cell[114729, 2344, 1419, 23, 166, "Text"],

Cell[CellGroupData[{
Cell[116173, 2371, 31, 0, 45, "Exercise"],
Cell[116207, 2373, 903, 21, 102, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[117147, 2399, 31, 0, 45, "Exercise"],
Cell[117181, 2401, 665, 15, 79, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[117883, 2421, 31, 0, 45, "Exercise"],
Cell[117917, 2423, 3043, 67, 423, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[120997, 2495, 31, 0, 45, "Exercise"],
Cell[121031, 2497, 1198, 29, 119, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[122266, 2531, 31, 0, 45, "Exercise"],
Cell[122300, 2533, 2059, 62, 255, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[124396, 2600, 31, 0, 45, "Exercise"],
Cell[124430, 2602, 1280, 42, 118, "ExerciseText"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

